package com.els.tso.contract.controller;

import com.els.tso.contract.util.VelocityUtil;
import com.els.tso.contract.util.WordToHtml;
import com.els.tso.contract.dao.FileUploadDao;
import com.els.tso.contract.entity.FileEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.*;
import java.util.Map;
import java.util.UUID;

@Controller
@RequestMapping("/fileUploadService")
public class FileUploadController {

    @Resource
    private FileUploadDao fileUploadDao;

    @PostMapping("/upload")
    @ResponseBody
    public String upload(@RequestPart("multipartFile") MultipartFile multipartFile) throws IOException {

        //获得文件名，
        String originalFilename = multipartFile.getOriginalFilename();
        String html ;
        if (originalFilename.endsWith(".docx")) {
            html = WordToHtml.getInstance().word2007ToHtml(multipartFile.getInputStream());
        } else {
            html = WordToHtml.getInstance().word2003ToHtml(multipartFile.getInputStream());
        }
        if (StringUtils.isBlank(html)) {
            return null;
        }
        FileEntity fileEntity = new FileEntity();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        fileEntity.setFileName(originalFilename);
        fileEntity.setContent(html);
        fileEntity.setUuid(uuid);
        fileUploadDao.insert(fileEntity);
        return uuid;
    }

    @PostMapping("/findFile")
    @ResponseBody
    public String findFile(@RequestParam("uuid") String uuid, @RequestBody Map<String, Object> params)  {
        FileEntity fileEntity = fileUploadDao.selectById(uuid);
        String str = fileEntity.getContent();

        return VelocityUtil.strEvaluate(str, params);
    }

}
