/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.srm.core.service.impl;

import com.els.tso.srm.core.service.RedisCacheService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisCacheCacheServiceImpl
implements RedisCacheService {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheCacheServiceImpl.class);
    private static final String LOCK_PRE = "LOCK:";
    private static final String CACHE_PRE = "CACHE:";
    private final RedisTemplate<Object, Object> redisTemplate;
    private final RedissonClient redissonClient;

    public RedisCacheCacheServiceImpl(RedisTemplate<Object, Object> redisTemplate, RedissonClient redissonClient) {
        this.redisTemplate = redisTemplate;
        this.redissonClient = redissonClient;
    }

    @Override
    public Object get(Object key) {
        return this.redisTemplate.boundValueOps((Object)(CACHE_PRE + key)).get();
    }

    @Override
    public void set(Object key, Object value) {
        this.redisTemplate.boundValueOps((Object)(CACHE_PRE + key)).set(value);
    }

    @Override
    public boolean getLock(String key) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(LOCK_PRE + key);
        return lock.tryLock(30L, TimeUnit.SECONDS);
    }

    @Override
    public boolean getLock(String key, long timeout) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(LOCK_PRE + key);
        return lock.tryLock(timeout, TimeUnit.SECONDS);
    }

    @Override
    public void releaseLock(String key) {
        RLock lock = this.redissonClient.getLock(LOCK_PRE + key);
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    @Override
    public void setWithExpire(String key, String value, long expire) {
        this.redisTemplate.boundValueOps((Object)(CACHE_PRE + key)).set((Object)value, expire, TimeUnit.MICROSECONDS);
    }

    @Override
    public void lset(String key, long index, Object value) {
        this.redisTemplate.boundListOps((Object)key).set(index, value);
    }

    @Override
    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Override
    public Long lpush(String key, Object value) {
        return this.redisTemplate.boundListOps((Object)key).leftPush(value);
    }

    @Override
    public Long lremove(String key, int count, String value) {
        return this.redisTemplate.boundListOps((Object)key).remove((long)count, (Object)value);
    }

    @Override
    public Object rpop(String key) {
        return this.redisTemplate.boundListOps((Object)key).rightPop();
    }

    @Override
    public List<Object> brpop(String key) {
        return this.redisTemplate.boundListOps((Object)key).range(0L, -1L);
    }

    @Override
    public List<Object> lrange(String key, long start, long end) {
        return this.redisTemplate.boundListOps((Object)key).range(start, end);
    }

    @Override
    public Long addSet(String key, Set<String> set) {
        return this.redisTemplate.boundSetOps((Object)key).add(new Object[]{set});
    }

    @Override
    public Boolean addZset(String key, Double score, String member) {
        return this.redisTemplate.boundZSetOps((Object)key).add((Object)member, score.doubleValue());
    }

    @Override
    public Long deleteZset(String key, String member) {
        return this.redisTemplate.boundZSetOps((Object)key).remove(new Object[]{member});
    }

    @Override
    public Set<Object> getZset(String key, long start, long end) {
        return this.redisTemplate.boundZSetOps((Object)key).range(start, end);
    }

    @Override
    public Long incr(String key) {
        return this.redisTemplate.boundValueOps((Object)key).increment();
    }

    @Override
    public void hset(String key, String field, byte[] value) {
        this.redisTemplate.boundHashOps((Object)key).put((Object)field, (Object)value);
    }

    @Override
    public Object hget(String key, String field) {
        return this.redisTemplate.boundHashOps((Object)key).get((Object)field);
    }

    @Override
    public Map<Object, Object> hgetAll(String key) {
        return this.redisTemplate.boundHashOps((Object)key).entries();
    }

    @Override
    public Boolean hdel(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Override
    public Long hlen(String key) {
        return this.redisTemplate.boundHashOps((Object)key).size();
    }
}

