package com.els.tso.srm.core.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.InputStream;
import java.util.List;
import java.util.Set;

/**
 * 文件传输对象
 *
 * @author daipj
 */
@Getter
@Setter
@ToString
public class MultipartFileParam implements java.io.Serializable {

    private static final long serialVersionUID = 6842230502389881345L;

    /**
     * 文件传输任务ID
     */
    private String identifier;
    /**
     * 文件名
     */
    private String filename;
    /**
     * 文件合成后的存储路径,可能是本地磁盘或网络路径
     */
    private String fileStorePath;
    /**
     * 当前为第几分片
     */
    private int chunkNumber;
    /**
     * 每个分块的固定大小
     */
    private long chunkSize;
    /**
     * 每个分块的当前大小
     */
    private long currentChunkSize;
    /**
     * 分片总数
     */
    private int totalChunks;
    /**
     * 附件总大小
     */
    private int totalSize;
    /**
     * 已上传分片
     */
    private Set<Integer> uploaded;
    /**
     * 附件片段流
     */
    private InputStream attachment;
}
