package com.els.tso.srm.core.service;


import com.els.tso.srm.core.model.MultipartFileParam;

import java.io.IOException;
import java.util.Set;

/**
 * @author daipj
 */
public interface FileChunkUploadService {
    /**
     * 文件分片上传
     *
     * @param multipartFileParam
     * @param userId
     * @return
     * @throws IOException
     */
    MultipartFileParam fileChunkUpload(MultipartFileParam multipartFileParam, String userId) throws IOException;

    /**
     * 获取哪些分片已上传
     *
     * @param identifier
     * @return
     */
    Set<Integer> getUploadedChunks(String identifier);
}
