package com.els.tso.srm.core.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author daipj
 * @date 2020/9/22 11:51
 */
public interface RedisCacheService {
    /**
     * get value
     *
     * @param key
     * @return
     */
    Object get(Object key);

    /**
     * set key and value
     *
     * @param key
     * @param value
     */
    void set(Object key, Object value);

    /**
     * 获取分布式锁,等待事件默认为30s
     *
     * @param key
     * @return
     * @throws InterruptedException
     */
    boolean getLock(String key) throws InterruptedException;

    /**
     * 获取分布式锁
     *
     * @param key
     * @param timeout 超时时间
     * @return
     * @throws InterruptedException
     */
    boolean getLock(String key, long timeout) throws InterruptedException;

    /**
     * 释放锁
     *
     * @param key
     */
    void releaseLock(String key);

    void setWithExpire(String key, String value, long expire);

    void lset(String key, long index, Object value);

    Boolean del(String key);

    Long lpush(String key, Object value);

    Long lremove(String key, int count, String value);

    Object rpop(String key);

    List<Object> brpop(String key);

    List<Object> lrange(String key, long start, long end);

    Long addSet(String key, Set<String> set);

    Boolean addZset(String key, Double score, String member);

    Long deleteZset(String key, String member);

    Set<Object> getZset(String key, long start, long end);

    Long incr(String key);

    void hset(String key, String field, byte[] value);

    Object hget(String key, String field);

    Map<Object, Object> hgetAll(String key);

    Boolean hdel(String key);

    Long hlen(String key);
}
