/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.sso.configuration;

import com.els.tso.common.dto.UserPrincipal;
import com.els.tso.common.util.AuthPrincipalHolder;
import com.els.tso.sso.configuration.CasProperties;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.AssertionHolder;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={AuthenticationFilter.class, AssertionThreadLocalFilter.class})
@Import(value={CasProperties.class})
public class SsoServletAndFilterAndListenerConfiguration {
    private final List<String> urlPatterns;
    private final CasProperties casProperties;

    public SsoServletAndFilterAndListenerConfiguration(CasProperties casProperties) {
        this.casProperties = casProperties;
        this.urlPatterns = casProperties.getUrlPatterns();
    }

    private Map<String, String> casConfig() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("casServerUrlPrefix", this.casProperties.getCasServerUrlPrefix());
        map.put("service", this.casProperties.getService());
        map.put("serverName", this.casProperties.getServerName());
        map.put("casServerLoginUrl", this.casProperties.getCasServerLoginUrl());
        return map;
    }

    @Bean
    public ServletListenerRegistrationBean<SingleSignOutHttpSessionListener> singleSignOutHttpSessionListener() {
        return new ServletListenerRegistrationBean((EventListener)new SingleSignOutHttpSessionListener());
    }

    @Bean
    public FilterRegistrationBean<SingleSignOutFilter> singleSignOutRegistrationBean() {
        FilterRegistrationBean singleSignOutFilterFilterRegistrationBean = new FilterRegistrationBean((Filter)new SingleSignOutFilter(), new ServletRegistrationBean[0]);
        singleSignOutFilterFilterRegistrationBean.setUrlPatterns(this.urlPatterns);
        return singleSignOutFilterFilterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<AuthenticationFilter> authenticationFilterRegistrationBean() {
        AuthenticationFilter authenticationFilter = new AuthenticationFilter();
        FilterRegistrationBean authenticationFilterFilterRegistrationBean = new FilterRegistrationBean((Filter)authenticationFilter, new ServletRegistrationBean[0]);
        authenticationFilterFilterRegistrationBean.setInitParameters(this.casConfig());
        authenticationFilterFilterRegistrationBean.setUrlPatterns(this.urlPatterns);
        authenticationFilterFilterRegistrationBean.setOrder(10);
        return authenticationFilterFilterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Cas20ProxyReceivingTicketValidationFilter> ticketValidationBeanRegistrationBean() {
        Cas20ProxyReceivingTicketValidationFilter cas20ProxyReceivingTicketValidationFilter = new Cas20ProxyReceivingTicketValidationFilter();
        FilterRegistrationBean ticketValidationRegistrationBean = new FilterRegistrationBean((Filter)cas20ProxyReceivingTicketValidationFilter, new ServletRegistrationBean[0]);
        ticketValidationRegistrationBean.setInitParameters(this.casConfig());
        ticketValidationRegistrationBean.setUrlPatterns(this.urlPatterns);
        ticketValidationRegistrationBean.setOrder(20);
        return ticketValidationRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<AssertionThreadLocalFilter> assertionThreadLocalFilterRegistrationBean() {
        FilterRegistrationBean assertionThreadLocalFilterRegistrationBean = new FilterRegistrationBean((Filter)new AssertionThreadLocalFilter(), new ServletRegistrationBean[0]);
        assertionThreadLocalFilterRegistrationBean.setUrlPatterns(this.urlPatterns);
        assertionThreadLocalFilterRegistrationBean.setOrder(30);
        return assertionThreadLocalFilterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<UserIdFilter> userIdFilterFilterRegistrationBean() {
        FilterRegistrationBean userIdFilterFilterRegistrationBean = new FilterRegistrationBean((Filter)new UserIdFilter(), new ServletRegistrationBean[0]);
        userIdFilterFilterRegistrationBean.setUrlPatterns(this.urlPatterns);
        userIdFilterFilterRegistrationBean.setOrder(40);
        return userIdFilterFilterRegistrationBean;
    }

    @Bean
    public RestTemplate restTemplate() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(10000);
        requestFactory.setReadTimeout(10000);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    static class UserIdFilter
    implements Filter {
        private static final Logger LOGGER = LoggerFactory.getLogger(UserIdFilter.class);

        UserIdFilter() {
        }

        public void init(FilterConfig filterConfig) {
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
            String userCode;
            Assertion assertion = AssertionHolder.getAssertion();
            if (null != assertion && !StringUtils.isEmpty((Object)(userCode = assertion.getPrincipal().getName()))) {
                AuthPrincipalHolder.setUser((UserPrincipal)new UserPrincipal(userCode));
            }
            chain.doFilter(servletRequest, servletResponse);
        }
    }
}

