/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.util.service.impl;

import com.els.tso.util.dao.ColumnsMapper;
import com.els.tso.util.pojo.bo.CopyTableBO;
import com.els.tso.util.pojo.entity.ColumnsEntity;
import com.els.tso.util.pojo.query.TableDataCopyQuery;
import com.els.tso.util.service.CopyByElsAccountService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class CopyByElsAccountServiceImpl
implements CopyByElsAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyByElsAccountServiceImpl.class);
    private static final String ELS_ACCOUNT = "elsAccount";
    private static final String UUID = "uuid";
    private static final String ID = "id";
    private static final String UUID_FUNCTION = "UUID()";
    @Resource
    private ColumnsMapper columnsMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tableDataCopy(TableDataCopyQuery query) {
        List<ColumnsEntity> columnsEntities = this.columnsMapper.selectColumnsByTableName(query.getTableSchema(), query.getTableName());
        LinkedMultiValueMap map = new LinkedMultiValueMap(32);
        columnsEntities.forEach(arg_0 -> CopyByElsAccountServiceImpl.lambda$tableDataCopy$0((MultiValueMap)map, arg_0));
        StringBuilder sqlBuilder = new StringBuilder();
        map.forEach((key, value) -> {
            StringBuilder columnBuilder = new StringBuilder();
            StringBuilder valueBuilder = new StringBuilder();
            value.forEach(column -> {
                if (!ID.equalsIgnoreCase(column.getColumnName())) {
                    columnBuilder.append(",");
                    valueBuilder.append(",");
                    columnBuilder.append("`");
                    columnBuilder.append(column.getColumnName());
                    columnBuilder.append("`");
                    if (ELS_ACCOUNT.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append("\"").append(query.getToElsAccount()).append("\"");
                    } else if (UUID.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append(UUID_FUNCTION);
                    } else {
                        valueBuilder.append("`");
                        valueBuilder.append(column.getColumnName());
                        valueBuilder.append("`");
                    }
                }
            });
            String columnStr = columnBuilder.toString().substring(1);
            String valueStr = valueBuilder.toString().substring(1);
            CopyTableBO copyTable = new CopyTableBO();
            copyTable.setTableName((String)key);
            copyTable.setColumnStr(columnStr);
            copyTable.setValueStr(valueStr);
            copyTable.setFromElsAccount(query.getFromElsAccount());
            copyTable.setToElsAccount(query.getToElsAccount());
            copyTable.setTableSchema(query.getTableSchema());
            sqlBuilder.append("insert ").append(copyTable.getTableName()).append("(").append(copyTable.getColumnStr()).append(")").append(" select ").append(copyTable.getValueStr()).append(" from ").append(copyTable.getTableName()).append(" where elsAccount ='").append(copyTable.getFromElsAccount()).append("';\n");
        });
        CopyTableBO copyTable = new CopyTableBO();
        copyTable.setFromElsAccount(query.getFromElsAccount());
        copyTable.setToElsAccount(query.getToElsAccount());
        String updateSql = " update enterprise_info\n        set toElsAccount = '%s',\n            fullName     =  '%s',\n            shortName    =  '%s'\n        where elsAccount = '%s';\n        update els_app\n        set appUrl = 'http://cs.51qqt.com/" + query.getAppContext() + "/uflo/designer'\n        where elsAccount = '%s'\n          and appCode = 'uflo_designer';\n";
        CopyTableBO copyTable2 = new CopyTableBO();
        copyTable2.setFromElsAccount(query.getFromElsAccount());
        copyTable2.setToElsAccount(query.getToElsAccount());
        copyTable2.setUpdateSql(updateSql);
        copyTable2.setAppContext(query.getAppContext());
        copyTable2.setEnterpriseName(query.getEnterpriseName());
        sqlBuilder.append(String.format(updateSql, copyTable2.getToElsAccount(), copyTable2.getEnterpriseName(), copyTable2.getEnterpriseName(), copyTable2.getToElsAccount(), copyTable2.getToElsAccount()));
        LOGGER.info("sql:\n{}", (Object)sqlBuilder);
        try (FileWriter fileWriter = new FileWriter(new File(String.format("D:/%s_data.sql", query.getToElsAccount())));){
            fileWriter.write(sqlBuilder.toString());
            fileWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("sql\u6570\u636e\u751f\u6210\u5f02\u5e38;", (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tableDataClear(TableDataCopyQuery query) {
        Arrays.asList(query.getTableName()).forEach(tableName -> {
            CopyTableBO copyTable = new CopyTableBO();
            copyTable.setToElsAccount(query.getToElsAccount());
            copyTable.setTableName((String)tableName);
            this.columnsMapper.clearTableData(copyTable);
        });
    }

    private static /* synthetic */ void lambda$tableDataCopy$0(MultiValueMap map, ColumnsEntity co) {
        map.add((Object)co.getTableName(), (Object)co);
    }
}

