/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TimeZoneKey;
import java.util.Objects;
import java.util.TimeZone;

public final class TimeZoneIndex {
    private static final TimeZone[] TIME_ZONES = new TimeZone[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];

    private TimeZoneIndex() {
    }

    public static TimeZone getTimeZoneForKey(TimeZoneKey timeZoneKey) {
        Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        return (TimeZone)TIME_ZONES[timeZoneKey.getKey()].clone();
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            String zoneId = timeZoneKey.getId();
            TimeZone timeZone = zoneId.charAt(0) == '-' || zoneId.charAt(0) == '+' ? TimeZone.getTimeZone("GMT" + zoneId) : TimeZone.getTimeZone(zoneId);
            TimeZoneIndex.TIME_ZONES[timeZoneKey.getKey()] = timeZone;
        }
    }
}

