package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.callback.BaseReceiveAllSignTaskCallbackReq;
import com.fasc.open.api.v5_1.req.callback.GetCallBackListReq;
import com.fasc.open.api.v5_1.req.callback.ListReceiveAllSignTaskCallbackReq;
import com.fasc.open.api.v5_1.res.callback.GetCallBackListRes;
import com.fasc.open.api.v5_1.res.callback.ListReceiveAllSignTaskCallbackRes;

import java.util.List;

/**
 * @author zhoufucheng
 * @date 2023/6/14 14:10
 */
public class CallBackClient {
    private OpenApiClient openApiClient;

    public CallBackClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<GetCallBackListRes> getCallBackList(GetCallBackListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_CALL_BACK_LIST, GetCallBackListRes.class);
    }

    public BaseRes<List<ListReceiveAllSignTaskCallbackRes>> listCallbackReceiveAllSignTask(ListReceiveAllSignTaskCallbackReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.GET_CALL_RECEIVE_ALL_SIGN_TASK_LIST, ListReceiveAllSignTaskCallbackRes.class);
    }

    public BaseRes<Void> callbackReceiveAllSignTask(BaseReceiveAllSignTaskCallbackReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CALL_RECEIVE_ALL_SIGN_TASK, Void.class);
    }

    public BaseRes<Void> callbackReceiveAllSignTaskCancel(BaseReceiveAllSignTaskCallbackReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CALL_RECEIVE_ALL_SIGN_TASK_CANCEL, Void.class);
    }
}
