/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.config;

import com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fbank.openapi.sdk.util.CertFileUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class Configuration {
    private static final int TIMEOUT_DEFAULT = 300000;

    public abstract String remoteAddress();

    public int connectionTimeout() {
        return 300000;
    }

    public int readTimeout() {
        return 300000;
    }

    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    public String signType() {
        return AlgorithmTypeEnum.RSA_HARDWARE.getAlgorithmType();
    }

    public String encryptType() {
        return AlgorithmTypeEnum.AES_CBC.getAlgorithmType();
    }

    public String fbankEncPubKey() {
        return CertFileUtils.getPublicKeyFromCerFile(this.fbankEncFileName());
    }

    public String fbankEncFileName() {
        return "Fbank_Public_CFCA_Enc.cer";
    }

    public String fbankSignPubKey() {
        return CertFileUtils.getPublicKeyFromCerFile(this.fbankSignFileName());
    }

    public String fbankSignFileName() {
        return "Fbank_Public_CFCA_Sign.cer";
    }

    public String privateKey() {
        return CertFileUtils.getPrivateKeyFromPfxFile(this.pfxFileName(), this.pfxPassword());
    }

    public abstract String pfxFileName();

    public abstract String pfxPassword();

    public abstract String merchantNo();

    @Deprecated
    public String channelNo() {
        return "";
    }

    public abstract String appId();

    public abstract String siteId();
}

