/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.crypto;

import com.fbank.openapi.sdk.crypto.BaseCryptoEncryptionStrategy;
import com.fbank.openapi.sdk.util.CertFileUtils;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractRSAEncryptionStrategy
implements BaseCryptoEncryptionStrategy {
    @Override
    public String encrypt(String data, String key) throws Exception {
        PublicKey publicKey = CertFileUtils.toPublicKey(key);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String decrypt(String data, String key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, CertFileUtils.toPrivateKey(key));
        return new String(cipher.doFinal(Base64.decodeBase64((String)data)), StandardCharsets.UTF_8);
    }
}

