/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.fbank.openapi.sdk.client.OpenParameters;
import com.fbank.openapi.sdk.config.Configuration;
import com.fbank.openapi.sdk.config.FileConfiguration;
import com.fbank.openapi.sdk.crypto.BaseCryptoSignatureStrategy;
import com.fbank.openapi.sdk.service.AbstractOpenApiFileService;
import com.fbank.openapi.sdk.util.CryptoServiceUtils;
import com.fbank.openapi.sdk.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class AbstractOpenApiFileDownloadService
extends AbstractOpenApiFileService {
    @Override
    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection, String moduleCode) {
        connection.setRequestProperty("algorithm", "fileDownload");
    }

    @Override
    protected String verifyAndDecrypt(HttpURLConnection connection, Configuration configuration, OpenParameters context, byte[] response) throws Exception {
        String bizContent = this.getBizContent(connection);
        JSONObject bizContentJO = JSONObject.parseObject((String)bizContent);
        JSONObject signDataJO = this.getSignDataJO(bizContentJO);
        String signature = this.getSignature(bizContentJO);
        if (StringUtils.isNotEmpty(signature)) {
            this.verifySignature(configuration, signDataJO, signature);
            this.verifyFile(bizContentJO, signDataJO, response);
            this.downloadFile(configuration, context, response, bizContentJO);
        }
        return this.getResponse(bizContentJO, signDataJO);
    }

    protected JSONObject getSignDataJO(JSONObject bizContentJO) {
        return bizContentJO.getJSONObject("sign_data");
    }

    protected String getSignature(JSONObject bizContentJO) {
        return bizContentJO.getString("signature");
    }

    protected void verifyFile(JSONObject bizContentJO, JSONObject signDataJO, byte[] response) throws Exception {
        this.checkFileMD5(signDataJO, response);
    }

    private void verifySignature(Configuration configuration, JSONObject signDataJO, String signature) throws Exception {
        TreeMap signDataTreeMap;
        JSONObject signDataSorted;
        BaseCryptoSignatureStrategy baseCryptoSignatureStrategy = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        boolean verifyResult = baseCryptoSignatureStrategy.verifySignature((signDataSorted = new JSONObject(signDataTreeMap = new TreeMap(signDataJO))).toJSONString(), signature, configuration.fbankSignPubKey());
        if (!verifyResult) {
            throw new RuntimeException("verifyFile failed!");
        }
    }

    protected String getFileName(Configuration configuration, OpenParameters context, JSONObject bizContentJO) {
        JSONObject signData = bizContentJO.getJSONObject("sign_data");
        String fileType = signData.getString("file_type");
        return this.getFileData(configuration, context, fileType);
    }

    protected String getFileData(Configuration configuration, OpenParameters context, String fileType) {
        String fileName;
        FileConfiguration fileConfiguration = (FileConfiguration)configuration;
        String storagePath = fileConfiguration.storagePath();
        if (!storagePath.endsWith("/")) {
            storagePath = storagePath + "/";
        }
        if ((fileName = context.getFileName()) == null) {
            fileName = String.valueOf(ThreadLocalRandom.current().nextInt());
        }
        if (!fileName.contains(".")) {
            fileName = fileName + "." + fileType;
        }
        return storagePath + fileName;
    }

    protected String getResponse(JSONObject bizContentJO, JSONObject signDataJO) {
        return "file download success";
    }

    private String getBizContent(HttpURLConnection connection) {
        String bizContent = connection.getHeaderField("biz_content");
        try {
            bizContent = URLDecoder.decode(bizContent, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.logger.info("bizContent is {}", (Object)bizContent);
        return bizContent;
    }

    private void downloadFile(Configuration configuration, OpenParameters context, byte[] response, JSONObject bizContentJO) {
        Path path = Paths.get(this.getFileName(configuration, context, bizContentJO), new String[0]);
        try {
            if (!Files.notExists(path, new LinkOption[0])) {
                throw new RuntimeException("file already exists");
            }
            Files.createFile(path, new FileAttribute[0]);
            Files.write(path, response, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("file download failed");
        }
    }

    private void checkFileMD5(JSONObject signDataJO, byte[] response) {
        String responseMd5 = DigestUtils.md5Hex((byte[])response);
        String signDataMd5 = signDataJO.getString("md5");
        this.logger.info("request md5 is {}, get md5 from file is {}", (Object)signDataMd5, (Object)responseMd5);
        if (!responseMd5.equalsIgnoreCase(signDataMd5)) {
            throw new RuntimeException("md5 check failed");
        }
    }
}

