/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.service;

import com.fbank.openapi.sdk.client.MultipartFile;
import com.fbank.openapi.sdk.client.OpenParameters;
import com.fbank.openapi.sdk.config.Configuration;
import com.fbank.openapi.sdk.service.AbstractOpenApiFileService;
import com.fbank.openapi.sdk.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class AbstractOpenApiFileUploadByFormService
extends AbstractOpenApiFileService {
    private static final String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    private static final String PREFIX = "--";
    private static final String LINE_END = "\r\n";

    @Override
    protected void setHttpHeaders(Configuration configuration, OpenParameters context, HttpURLConnection connection) throws Exception {
        super.setHttpHeaders(configuration, context, connection);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        connection.setRequestProperty("serial_number", context.getSerialNumber());
    }

    @Override
    protected TreeMap<String, Object> getRequestTreeMap(Configuration configuration, OpenParameters context) throws Exception {
        TreeMap<String, Object> treeMap = super.getRequestTreeMap(configuration, context);
        this.addFileData(context, treeMap);
        return treeMap;
    }

    @Override
    protected void writeRequest(OutputStream outputStream, OpenParameters context, byte[] encryptedBodyBytes) throws IOException {
        this.writeParam(outputStream, encryptedBodyBytes);
        this.writeFile(context, outputStream);
        String endTarget = PREFIX + BOUNDARY + PREFIX + LINE_END;
        outputStream.write(endTarget.getBytes());
    }

    protected abstract String getHttpHeaderBizContentKey();

    private void writeParam(OutputStream outputStream, byte[] encryptedBodyBytes) throws IOException {
        String requestParams = PREFIX + BOUNDARY + LINE_END + "Content-Disposition: form-data; name=\"" + this.getHttpHeaderBizContentKey() + "\"" + LINE_END + "Content-Type: text/plain; charset=utf-8" + LINE_END + "Content-Transfer-Encoding: 8bit" + LINE_END + LINE_END;
        outputStream.write(requestParams.getBytes());
        outputStream.write(encryptedBodyBytes);
        outputStream.write(LINE_END.getBytes());
        outputStream.flush();
    }

    private void writeFile(OpenParameters context, OutputStream outputStream) throws IOException {
        byte[] fileBytes;
        MultipartFile multipartFile = context.getMultipartFile();
        String fileName = multipartFile.getName();
        if (StringUtils.isEmpty(fileName)) {
            fileName = context.getFileName();
        }
        if ((fileBytes = multipartFile.getBytes()) == null || fileBytes.length == 0) {
            fileBytes = context.getFileBytes();
        }
        String requestParams = PREFIX + BOUNDARY + LINE_END + "Content-Disposition: form-data; name=\"" + "file" + "\"; filename=\"" + fileName + "\"" + LINE_END + "Content-Type:application/octet-stream" + LINE_END + "Content-Transfer-Encoding: 8bit" + LINE_END + LINE_END;
        outputStream.write(requestParams.getBytes());
        outputStream.write(fileBytes);
        outputStream.write(LINE_END.getBytes());
        outputStream.flush();
    }

    private MultipartFile getMultipartFile(OpenParameters context) throws IOException {
        try (InputStream inputStream = context.getInputStream();){
            String uploadPath = context.getUploadPath();
            String fileName = String.valueOf(System.currentTimeMillis());
            if (inputStream == null && StringUtils.isNotEmpty(uploadPath)) {
                String[] split = this.getFileNameSplit(uploadPath);
                fileName = split[0];
                MultipartFile multipartFile = new MultipartFile(fileName, new FileInputStream(uploadPath));
                return multipartFile;
            }
            MultipartFile multipartFile = new MultipartFile(fileName, inputStream);
            return multipartFile;
        }
    }

    private void addFileData(OpenParameters context, TreeMap<String, Object> treeMap) throws IOException {
        MultipartFile multipartFile = this.getMultipartFile(context);
        context.setMultipartFile(multipartFile);
        byte[] fileBytes = multipartFile.getBytes();
        if (fileBytes == null || fileBytes.length == 0) {
            fileBytes = context.getFileBytes();
        }
        String md5Hex = DigestUtils.md5Hex((byte[])fileBytes);
        String fileType = this.getFileType(context);
        treeMap.put("fileType", fileType);
        if (StringUtils.isNotEmpty(context.getRuleCode())) {
            treeMap.put("ruleCode", context.getRuleCode());
        }
        treeMap.put("md5", md5Hex);
    }

    private String getFileType(OpenParameters context) {
        String fileType = context.getFileType();
        String uploadPath = context.getUploadPath();
        if (StringUtils.isEmpty(fileType) && StringUtils.isNotEmpty(uploadPath)) {
            String[] fileNameSplit = this.getFileNameSplit(uploadPath);
            fileType = fileNameSplit[fileNameSplit.length - 1];
        }
        return fileType;
    }

    private String[] getFileNameSplit(String uploadPath) {
        Path path = Paths.get(uploadPath, new String[0]);
        String fileNameAll = path.getFileName().toString();
        return fileNameAll.split("\\.");
    }
}

