/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fbank.openapi.sdk.client.FBankOpenApiClient;
import com.fbank.openapi.sdk.client.OpenParameters;
import com.fbank.openapi.sdk.config.Configuration;
import com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fbank.openapi.sdk.constant.ModuleCodeEnum;
import com.fbank.openapi.sdk.crypto.BaseCryptoEncryptionStrategy;
import com.fbank.openapi.sdk.crypto.BaseCryptoSignatureStrategy;
import com.fbank.openapi.sdk.service.OpenApiService;
import com.fbank.openapi.sdk.util.AESUtils;
import com.fbank.openapi.sdk.util.CryptoServiceUtils;
import com.fbank.openapi.sdk.util.SerialNoUtils;
import com.fbank.openapi.sdk.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenApiService
implements OpenApiService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String execute(FBankOpenApiClient client, OpenParameters context) throws Exception {
        Configuration configuration = client.getConfiguration();
        byte[] body = this.buildBody(configuration, context);
        HttpURLConnection connection = this.getHttpURLConnection(configuration, context);
        byte[] response = this.getResponse(connection, context, body);
        String bizData = this.verifyAndDecrypt(connection, configuration, context, response);
        connection.disconnect();
        return this.assembleBizData(configuration, bizData, response);
    }

    protected byte[] buildBody(Configuration configuration, OpenParameters context) throws Exception {
        TreeMap<String, Object> requestMap = this.getRequestTreeMap(configuration, context);
        JSONObject requestBodyJO = this.assembleBody(configuration, requestMap);
        return requestBodyJO.toJSONString().getBytes(configuration.charset());
    }

    protected TreeMap<String, Object> getRequestTreeMap(Configuration configuration, OpenParameters context) throws Exception {
        String randomKey = AESUtils.randomKey();
        String encryptType = configuration.encryptType();
        BaseCryptoEncryptionStrategy aesEncryptionService = CryptoServiceUtils.getCryptoAESEncryptionService(encryptType);
        String data = aesEncryptionService.encrypt(context.getParams(), randomKey);
        this.logger.info("randomKey is {}, encryptType is {}, encrypt result is {}", new Object[]{randomKey, encryptType, data});
        String signType = configuration.signType();
        BaseCryptoEncryptionStrategy rsaEncryptionService = CryptoServiceUtils.getCryptoRSAEncryptionService(signType);
        String randomKeyEncrypt = rsaEncryptionService.encrypt(randomKey, configuration.fbankEncPubKey());
        this.logger.info("signType is {}, randomKeyEncrypt is {}", (Object)signType, (Object)randomKeyEncrypt);
        TreeMap<String, Object> requestMap = new TreeMap<String, Object>();
        requestMap.put("data", data);
        requestMap.put("randomKeyEncrypt", randomKeyEncrypt);
        requestMap.put("merchantNo", configuration.merchantNo());
        if (StringUtils.isNotEmpty(configuration.channelNo())) {
            requestMap.put("channelNo", configuration.channelNo());
        }
        requestMap.put("sdkVersion", "2.5.0");
        requestMap.put("timestamp", System.currentTimeMillis());
        requestMap.put("signType", signType);
        requestMap.put("encryptType", encryptType);
        if (StringUtils.isNotEmpty(configuration.appId()) && StringUtils.isNotEmpty(configuration.siteId())) {
            requestMap.put("appId", configuration.appId());
            requestMap.put("siteId", configuration.siteId());
        }
        if (StringUtils.isNotEmpty(context.getUserId())) {
            requestMap.put("userId", context.getUserId());
        }
        return requestMap;
    }

    JSONObject assembleBody(Configuration configuration, TreeMap<String, Object> requestMap) throws Exception {
        JSONObject requestJO = new JSONObject(requestMap);
        String requestJSONString = requestJO.toJSONString();
        BaseCryptoSignatureStrategy baseCryptoSignatureStrategy = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        String signData = baseCryptoSignatureStrategy.signature(requestJSONString, configuration);
        this.logger.info("signature result is {}", (Object)signData);
        requestJO.put("signData", (Object)signData);
        return requestJO;
    }

    protected String verifyAndDecrypt(HttpURLConnection connection, Configuration configuration, OpenParameters context, byte[] response) throws Exception {
        String responseStr = new String(response, configuration.charset());
        JSONObject responseJO = JSONObject.parseObject((String)responseStr);
        if (null == responseJO || !responseJO.containsKey((Object)"signData")) {
            return responseStr;
        }
        String pubKey = configuration.fbankSignPubKey();
        JSONObject json = this.verifySignature(configuration, responseStr, pubKey);
        return this.decryptResult(configuration, json);
    }

    protected String getRemoteAddress(Configuration configuration) {
        return configuration.remoteAddress();
    }

    protected void setHttpHeaders(Configuration configuration, OpenParameters context, HttpURLConnection connection) throws Exception {
        String serialNumber;
        String clientSerialNo;
        String moduleCode;
        connection.setRequestProperty("api_name", context.getApiName());
        String apiCode = context.getApiCode();
        if (StringUtils.isNotEmpty(apiCode)) {
            connection.setRequestProperty("api_code", apiCode);
        }
        if (StringUtils.isNotEmpty(moduleCode = context.getModuleCode())) {
            connection.setRequestProperty("module_code", moduleCode);
        }
        this.setAlgorithm(configuration, connection, moduleCode);
        String apiVersion = context.getApiVersion();
        if (StringUtils.isNotEmpty(apiVersion)) {
            connection.setRequestProperty("api_version", apiVersion);
        }
        if (StringUtils.isNotEmpty(clientSerialNo = SerialNoUtils.calculateSerialNo(context.getParams()))) {
            connection.setRequestProperty("client_serial_no", clientSerialNo);
        }
        if (StringUtils.isNotEmpty(serialNumber = context.getSerialNumber())) {
            connection.setRequestProperty("serial_number", serialNumber);
        }
        connection.setRequestProperty("Content-Type", "application/json");
    }

    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection, String moduleCode) {
        if (AlgorithmTypeEnum.RSA_HARDWARE.getAlgorithmType().equals(configuration.signType())) {
            connection.setRequestProperty("algorithm", "rsaDetached");
        }
        if (null != moduleCode && ModuleCodeEnum.OPEN_API_BASE_SERVICE.rawValue().equalsIgnoreCase(moduleCode)) {
            connection.setRequestProperty("algorithm", "rsaService");
        }
    }

    protected String getHttpMethod() {
        return "POST";
    }

    protected void writeRequest(OutputStream outputStream, OpenParameters context, byte[] encryptedBodyBytes) throws IOException {
        outputStream.write(encryptedBodyBytes);
    }

    private JSONObject verifySignature(Configuration configuration, String encryptedResult, String publicKey) throws Exception {
        Map encryptedResultMap = (Map)JSONObject.parseObject((String)encryptedResult, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        Object signData = encryptedResultMap.remove("signData");
        JSONObject encryptedResultJson = new JSONObject(encryptedResultMap);
        BaseCryptoSignatureStrategy cryptoService = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        boolean verifyResult = cryptoService.verifySignature(encryptedResultJson.toJSONString(), signData.toString(), publicKey);
        if (!verifyResult) {
            this.logger.error("The result signature verify failed, encryptedResult is : {} ", (Object)encryptedResult);
            throw new IllegalArgumentException("Verify signature failed.");
        }
        return encryptedResultJson;
    }

    private String decryptResult(Configuration configuration, JSONObject json) throws Exception {
        String encryptedRandomKey = json.getString("randomKeyEncrypt");
        BaseCryptoEncryptionStrategy rsaBaseCryptoEncryptionStrategy = CryptoServiceUtils.getCryptoRSAEncryptionService(configuration.signType());
        String randomKey = rsaBaseCryptoEncryptionStrategy.decrypt(encryptedRandomKey, configuration.privateKey());
        BaseCryptoEncryptionStrategy aesBaseCryptoEncryptionStrategy = CryptoServiceUtils.getCryptoAESEncryptionService(configuration.encryptType());
        return aesBaseCryptoEncryptionStrategy.decrypt(json.getString("data"), randomKey);
    }

    private HttpURLConnection getHttpURLConnection(Configuration configuration, OpenParameters context) throws Exception {
        URL url = new URL(this.pseudoModuleCode(context, this.getRemoteAddress(configuration)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setHttpHeaders(configuration, context, connection);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(this.getHttpMethod());
        connection.setConnectTimeout(configuration.connectionTimeout());
        connection.setReadTimeout(configuration.readTimeout());
        return connection;
    }

    private String pseudoModuleCode(OpenParameters context, String address) {
        if (!address.endsWith("/")) {
            address = address + "/";
        }
        if (ModuleCodeEnum.OPEN_API_FUNCTION.rawValue().equalsIgnoreCase(context.getModuleCode())) {
            address = address + "?function=" + context.getApiCode();
        }
        return address;
    }

    private byte[] getResponse(HttpURLConnection connection, OpenParameters context, byte[] encryptedBodyBytes) throws IOException {
        try (OutputStream outputStream = connection.getOutputStream();){
            if (null != encryptedBodyBytes) {
                this.writeRequest(outputStream, context, encryptedBodyBytes);
                outputStream.flush();
            }
            byte[] byArray = this.readResponse(connection);
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] readResponse(HttpURLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String assembleBizData(Configuration configuration, String bizData, byte[] response) {
        return bizData;
    }

    protected String getUnifyBizData(Configuration configuration, String bizData, byte[] response) {
        String responseStr = new String(response, configuration.charset());
        JSONObject responseJO = JSONObject.parseObject((String)responseStr);
        JSONObject bizDataJO = JSONObject.parseObject((String)bizData);
        return this.getUnifyBizData(responseJO, bizDataJO);
    }

    protected String getUnifyBizData(JSONObject responseJO, JSONObject bizDataJO) {
        JSONObject responseAssembleJO = new JSONObject((Map)responseJO);
        if (StringUtils.isNotEmpty(responseJO.getString("signData")) && StringUtils.isEmpty(bizDataJO.getString("signData"))) {
            responseAssembleJO.remove((Object)"signData");
            responseAssembleJO.put("result", (Object)bizDataJO);
        }
        if (StringUtils.isNotEmpty(responseJO.getString("data")) && StringUtils.isEmpty(bizDataJO.getString("data"))) {
            responseAssembleJO.remove((Object)"data");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("randomKeyEncrypt")) && StringUtils.isEmpty(bizDataJO.getString("randomKeyEncrypt"))) {
            responseAssembleJO.remove((Object)"randomKeyEncrypt");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("merchantNo")) && StringUtils.isEmpty(bizDataJO.getString("merchantNo"))) {
            responseAssembleJO.remove((Object)"merchantNo");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("channelNo")) && StringUtils.isEmpty(bizDataJO.getString("channelNo"))) {
            responseAssembleJO.remove((Object)"channelNo");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("signType")) && StringUtils.isEmpty(bizDataJO.getString("signType"))) {
            responseAssembleJO.remove((Object)"signType");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("encryptType")) && StringUtils.isEmpty(bizDataJO.getString("encryptType"))) {
            responseAssembleJO.remove((Object)"encryptType");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("sdkVersion")) && StringUtils.isEmpty(bizDataJO.getString("sdkVersion"))) {
            responseAssembleJO.remove((Object)"sdkVersion");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("appId")) && StringUtils.isEmpty(bizDataJO.getString("appId"))) {
            responseAssembleJO.remove((Object)"appId");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("siteId")) && StringUtils.isEmpty(bizDataJO.getString("siteId"))) {
            responseAssembleJO.remove((Object)"siteId");
        }
        if (StringUtils.isNotEmpty(responseJO.getString("userId")) && StringUtils.isEmpty(bizDataJO.getString("userId"))) {
            responseAssembleJO.remove((Object)"userId");
        }
        return responseAssembleJO.toJSONString();
    }

    protected String jsonToString(JSONObject jsonObject) {
        return jsonObject.toJSONString();
    }
}

