/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.fbank.openapi.sdk.constant.FileDownloadStatusEnum;
import com.fbank.openapi.sdk.service.AbstractOpenApiFileDownloadService;

public class OpenApiFileDownloadService
extends AbstractOpenApiFileDownloadService {
    @Override
    protected String getFileRequestPath() {
        return "api/download";
    }

    @Override
    protected JSONObject getSignDataJO(JSONObject bizContentJO) {
        this.checkResponseCode(bizContentJO);
        return bizContentJO.getJSONObject("sign_data");
    }

    @Override
    protected void verifyFile(JSONObject bizContentJO, JSONObject signDataJO, byte[] response) throws Exception {
        OpenApiFileDownloadService.checkFileStatus(signDataJO);
        super.verifyFile(bizContentJO, signDataJO, response);
    }

    private void checkResponseCode(JSONObject bizContentJO) {
        String code = bizContentJO.getString("code");
        if (!"000000".equalsIgnoreCase(code)) {
            throw new RuntimeException(bizContentJO.getString("message"));
        }
    }

    private static void checkFileStatus(JSONObject signDataJO) {
        String status = signDataJO.getString("status");
        if (FileDownloadStatusEnum.SUCCESS.getStatus().equalsIgnoreCase(status)) {
            return;
        }
        for (FileDownloadStatusEnum fileDownloadStatus : FileDownloadStatusEnum.values()) {
            if (!fileDownloadStatus.getStatus().equalsIgnoreCase(status)) continue;
            throw new RuntimeException(fileDownloadStatus.getMessage());
        }
        throw new RuntimeException(FileDownloadStatusEnum.OTHER.getMessage());
    }
}

