/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.fbank.openapi.sdk.client.OpenParameters;
import com.fbank.openapi.sdk.config.Configuration;
import com.fbank.openapi.sdk.service.AbstractOpenApiFileService;
import com.fbank.openapi.sdk.util.StringUtils;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;

public class OpenApiFileUploadService
extends AbstractOpenApiFileService {
    @Override
    protected String getFileRequestPath() {
        return "api/upload";
    }

    @Override
    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection, String moduleCode) {
        connection.setRequestProperty("algorithm", "fileUpload");
    }

    @Override
    protected byte[] buildBody(Configuration configuration, OpenParameters context) throws Exception {
        String uploadPath = context.getUploadPath();
        Path path = Paths.get(uploadPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("file does not exist");
        }
        byte[] bytes = Files.readAllBytes(path);
        String md5Hex = DigestUtils.md5Hex((byte[])bytes);
        context.setMd5(md5Hex);
        return bytes;
    }

    @Override
    protected void setHttpHeaders(Configuration configuration, OpenParameters context, HttpURLConnection connection) throws Exception {
        super.setHttpHeaders(configuration, context, connection);
        TreeMap<String, Object> requestMap = new TreeMap<String, Object>();
        requestMap.put("data", context.getParams());
        requestMap.put("signType", configuration.signType());
        requestMap.put("encryptType", configuration.encryptType());
        requestMap.put("fileType", this.getFileType(context));
        requestMap.put("ruleCode", context.getRuleCode());
        requestMap.put("serialNumber", context.getSerialNumber());
        requestMap.put("merchantNo", configuration.merchantNo());
        requestMap.put("md5", context.getMd5());
        requestMap.put("timestamp", System.currentTimeMillis());
        if (StringUtils.isNotEmpty(configuration.appId()) && StringUtils.isNotEmpty(configuration.siteId())) {
            requestMap.put("appId", configuration.appId());
            requestMap.put("siteId", configuration.siteId());
        }
        JSONObject requestJO = this.assembleBody(configuration, requestMap);
        connection.setRequestProperty("biz_content", URLEncoder.encode(requestJO.toJSONString(), configuration.charset().name()));
        connection.setRequestProperty("Content-Type", "application/octet-stream");
    }

    private String getFileType(OpenParameters context) {
        String fileType = context.getFileType();
        String uploadPath = context.getUploadPath();
        if (StringUtils.isEmpty(fileType) && StringUtils.isNotEmpty(uploadPath)) {
            String[] fileNameSplit = this.getFileNameSplit(uploadPath);
            fileType = fileNameSplit[fileNameSplit.length - 1];
        }
        return fileType;
    }

    private String[] getFileNameSplit(String uploadPath) {
        Path path = Paths.get(uploadPath, new String[0]);
        String fileNameAll = path.getFileName().toString();
        return fileNameAll.split("\\.");
    }
}

