/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.util;

import com.fbank.openapi.sdk.crypto.AESWithCBCEncryptionStrategy;
import com.fbank.openapi.sdk.crypto.AESWithECBEncryptionStrategy;
import com.fbank.openapi.sdk.crypto.BaseCryptoEncryptionStrategy;
import com.fbank.openapi.sdk.crypto.BaseCryptoSignatureStrategy;
import com.fbank.openapi.sdk.crypto.RSAWithHardwareStrategy;
import com.fbank.openapi.sdk.crypto.RSAWithSoftwareStrategy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoServiceUtils.class);
    private static volatile Map<String, BaseCryptoEncryptionStrategy> cryptoAESEncryptionServiceMap = new HashMap<String, BaseCryptoEncryptionStrategy>();
    private static volatile Map<String, BaseCryptoEncryptionStrategy> cryptoRSAEncryptionServiceMap = new HashMap<String, BaseCryptoEncryptionStrategy>();
    private static volatile Map<String, BaseCryptoSignatureStrategy> cryptoSignatureServiceMap = new HashMap<String, BaseCryptoSignatureStrategy>();

    public static BaseCryptoEncryptionStrategy getCryptoAESEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoAESEncryptionServiceMap.get(typeUpperCase);
    }

    public static void putCryptoAESEncryptionService(BaseCryptoEncryptionStrategy baseCryptoEncryptionStrategy) {
        if (baseCryptoEncryptionStrategy != null) {
            cryptoAESEncryptionServiceMap.put(baseCryptoEncryptionStrategy.getAlgorithmType(), baseCryptoEncryptionStrategy);
        }
    }

    public static BaseCryptoEncryptionStrategy getCryptoRSAEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoRSAEncryptionServiceMap.get(typeUpperCase);
    }

    public static void putCryptoRSAEncryptionService(BaseCryptoEncryptionStrategy baseCryptoEncryptionStrategy) {
        if (baseCryptoEncryptionStrategy != null) {
            cryptoRSAEncryptionServiceMap.put(baseCryptoEncryptionStrategy.getAlgorithmType(), baseCryptoEncryptionStrategy);
        }
    }

    public static BaseCryptoSignatureStrategy getCryptoSignatureService(String signType) throws Exception {
        String typeUpperCase = signType.toUpperCase(Locale.getDefault());
        return cryptoSignatureServiceMap.get(typeUpperCase);
    }

    public static void putCryptoSignatureService(BaseCryptoSignatureStrategy baseCryptoSignatureStrategy) {
        if (baseCryptoSignatureStrategy != null) {
            cryptoSignatureServiceMap.put(baseCryptoSignatureStrategy.getAlgorithmType(), baseCryptoSignatureStrategy);
        }
    }

    private static void initialCryptoService() throws Exception {
        HashSet<BaseCryptoEncryptionStrategy> cryptoAESEncryptionServiceSet = new HashSet<BaseCryptoEncryptionStrategy>();
        cryptoAESEncryptionServiceSet.add(new AESWithCBCEncryptionStrategy());
        cryptoAESEncryptionServiceSet.add(new AESWithECBEncryptionStrategy());
        CryptoServiceUtils.initialCryptoAESEncryptionService(cryptoAESEncryptionServiceSet);
        HashSet<BaseCryptoEncryptionStrategy> cryptoRSAEncryptionServiceSet = new HashSet<BaseCryptoEncryptionStrategy>();
        cryptoRSAEncryptionServiceSet.add(new RSAWithHardwareStrategy());
        cryptoRSAEncryptionServiceSet.add(new RSAWithSoftwareStrategy());
        CryptoServiceUtils.initialCryptoRSAEncryptionService(cryptoRSAEncryptionServiceSet);
        HashSet<BaseCryptoSignatureStrategy> baseCryptoSignatureStrategySet = new HashSet<BaseCryptoSignatureStrategy>();
        baseCryptoSignatureStrategySet.add(new RSAWithHardwareStrategy());
        baseCryptoSignatureStrategySet.add(new RSAWithSoftwareStrategy());
        CryptoServiceUtils.initialCryptoSignatureService(baseCryptoSignatureStrategySet);
    }

    private static void initialCryptoAESEncryptionService(HashSet<BaseCryptoEncryptionStrategy> baseCryptoEncryptionStrategyClassSet) throws Exception {
        for (BaseCryptoEncryptionStrategy baseCryptoEncryptionStrategy : baseCryptoEncryptionStrategyClassSet) {
            cryptoAESEncryptionServiceMap.put(baseCryptoEncryptionStrategy.getAlgorithmType(), baseCryptoEncryptionStrategy);
        }
    }

    private static void initialCryptoRSAEncryptionService(HashSet<BaseCryptoEncryptionStrategy> baseCryptoEncryptionStrategyClassSet) throws Exception {
        for (BaseCryptoEncryptionStrategy baseCryptoEncryptionStrategy : baseCryptoEncryptionStrategyClassSet) {
            cryptoRSAEncryptionServiceMap.put(baseCryptoEncryptionStrategy.getAlgorithmType(), baseCryptoEncryptionStrategy);
        }
    }

    private static void initialCryptoSignatureService(HashSet<BaseCryptoSignatureStrategy> baseCryptoSignatureStrategySet) throws Exception {
        for (BaseCryptoSignatureStrategy baseCryptoSignatureStrategy : baseCryptoSignatureStrategySet) {
            cryptoSignatureServiceMap.put(baseCryptoSignatureStrategy.getAlgorithmType(), baseCryptoSignatureStrategy);
        }
    }

    static {
        try {
            CryptoServiceUtils.initialCryptoService();
        }
        catch (Exception e) {
            LOGGER.error("initial crypto service failed!");
        }
    }
}

