/*
 * Decompiled with CFR 0.152.
 */
package com.fbank.openapi.sdk.util;

import com.fbank.openapi.sdk.config.Configuration;
import com.fbank.openapi.sdk.util.CertFileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String SHA256 = "SHA256";

    public static String signature(String data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(SHA256_WITH_RSA);
        signature.initSign(CertFileUtils.toPrivateKey(privateKey));
        signature.update(data.getBytes());
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verifySignature(String data, String signature, String publicKey) throws Exception {
        PublicKey pubKey = CertFileUtils.toPublicKey(publicKey);
        Signature sign = Signature.getInstance(SHA256_WITH_RSA);
        sign.initVerify(pubKey);
        sign.update(data.getBytes(StandardCharsets.UTF_8));
        return sign.verify(Base64.decodeBase64((String)signature));
    }

    public static String detachSign(byte[] dataBytes, Configuration configuration) throws Exception {
        Signature signature = Signature.getInstance(SHA256_WITH_RSA);
        signature.initSign(CertFileUtils.toPrivateKey(configuration.privateKey()));
        signature.update(dataBytes, 0, dataBytes.length);
        return RSAUtils.base64Encode(RSAUtils.createPKCS7(configuration, signature.sign()));
    }

    private static byte[] createPKCS7(Configuration configuration, byte[] signedDataBytes) throws NoSuchAlgorithmException, IOException {
        AlgorithmId[] digestAlgorithmIds = new AlgorithmId[]{AlgorithmId.get(SHA256)};
        ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, null);
        X509Certificate certificate = RSAUtils.getSignCert(configuration.pfxFileName(), configuration.pfxPassword());
        if (certificate != null) {
            X509Certificate[] certificates = new X509Certificate[]{certificate};
            SignerInfo si = new SignerInfo((X500Name)certificate.getIssuerDN(), certificate.getSerialNumber(), AlgorithmId.get(SHA256), null, new AlgorithmId(AlgorithmId.RSAEncryption_oid), signedDataBytes, null);
            SignerInfo[] signerInfo = new SignerInfo[]{si};
            PKCS7 p7 = new PKCS7(digestAlgorithmIds, contentInfo, certificates, signerInfo);
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                p7.encodeSignedData(bout);
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
        }
        throw new IllegalArgumentException("something wrong with cert file, pls check it!");
    }

    private static X509Certificate getSignCert(String pfxFileName, String pfxPassword) {
        try {
            KeyStore keyStore = CertFileUtils.getKeyStore(pfxFileName, pfxPassword);
            String keyAlias = CertFileUtils.getKeyAlias(keyStore);
            return (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            LOGGER.error("get sign cert error ", (Throwable)e);
            return null;
        }
    }

    private static String base64Encode(byte[] data) {
        String strRet = Base64.encodeBase64String((byte[])data);
        strRet = strRet.replaceAll("\r\n", "");
        strRet = strRet.replaceAll("\n", "");
        strRet = strRet.replaceAll(" ", "");
        strRet = strRet.replaceAll("\t", "");
        return strRet;
    }

    public static boolean detachVerify(byte[] originData, String signedData) throws NoSuchAlgorithmException, SignatureException, IOException {
        if (signedData == null) {
            throw new IllegalArgumentException("signedData can't be null");
        }
        PKCS7 exp = new PKCS7(Base64.decodeBase64((String)signedData));
        SignerInfo[] signers = originData == null ? exp.verify() : exp.verify(originData);
        if (signers != null) {
            X509Certificate[] certs = exp.getCertificates();
            return certs[0].getSerialNumber().equals(signers[0].getCertificateSerialNumber());
        }
        return false;
    }
}

