/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp;

import com.alibaba.fastjson.JSON;
import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.FileCacheStorager;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.mp.WeixinProxy;
import com.foxinmy.weixin4j.mp.api.ComponentApi;
import com.foxinmy.weixin4j.mp.model.WeixinMpAccount;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class WeixinComponentProxy {
    private Map<String, ComponentApi> componentMap;
    private final WeixinMpAccount weixinMpAccount;
    public static final String VERSION = "1.7.4";

    public WeixinComponentProxy() {
        this((CacheStorager<Token>)new FileCacheStorager());
    }

    public WeixinComponentProxy(CacheStorager<Token> cacheStorager) {
        this((WeixinMpAccount)((Object)JSON.parseObject((String)Weixin4jConfigUtil.getValue((String)"account"), WeixinMpAccount.class)), cacheStorager);
    }

    public WeixinComponentProxy(WeixinMpAccount weixinMpAccount, CacheStorager<Token> cacheStorager) {
        if (weixinMpAccount == null) {
            throw new IllegalArgumentException("weixinMpAccount must not be empty");
        }
        if (cacheStorager == null) {
            throw new IllegalArgumentException("cacheStorager must not be empty");
        }
        this.weixinMpAccount = weixinMpAccount;
        this.componentMap = new HashMap<String, ComponentApi>(weixinMpAccount.getComponents().size());
        for (WeixinAccount component : weixinMpAccount.getComponents()) {
            this.componentMap.put(component.getId(), new ComponentApi(new TicketManager(component.getId(), component.getSecret(), cacheStorager)));
        }
        this.componentMap.put(null, this.componentMap.get(weixinMpAccount.getComponents().get(0).getId()));
    }

    public WeixinMpAccount getWeixinMpAccount() {
        return this.weixinMpAccount;
    }

    public ComponentApi component() {
        return this.componentMap.get(null);
    }

    public ComponentApi component(String componentId) {
        return this.componentMap.get(componentId);
    }

    public String getPreComponentTicket(String componentId) throws WeixinException {
        ComponentApi component = this.component(componentId);
        Token token = component.getTicketManager().getTicket();
        if (token == null || StringUtil.isBlank((CharSequence)token.getAccessToken())) {
            throw new WeixinException("maybe oauth first?");
        }
        return component.getPreCodeManager().getAccessToken();
    }

    public void cacheComponentTicket(String componentId, String componentTicket) throws WeixinException {
        this.component(componentId).getTicketManager().cachingTicket(componentTicket);
    }

    public String getComponentAuthorizationURL(String componentId) throws WeixinException {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"component.oauth.redirect.uri");
        return this.getComponentAuthorizationURL(componentId, redirectUri, "state");
    }

    public String getComponentAuthorizationURL(String componentId, String redirectUri, String state) throws WeixinException {
        try {
            return String.format("https://mp.weixin.qq.com/cgi-bin/componentloginpage?component_appid=%s&pre_auth_code=%s&redirect_uri=%s", componentId, this.getPreComponentTicket(componentId), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public WeixinProxy getWeixinProxy(String componentId, String authAppId) {
        return new WeixinProxy(this.component(componentId).getRefreshTokenManager(authAppId), this.component(componentId).getTokenManager());
    }
}

