/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.card.CardCoupon;
import com.foxinmy.weixin4j.model.card.CardQR;
import com.foxinmy.weixin4j.model.card.MemberInitInfo;
import com.foxinmy.weixin4j.model.card.MemberUpdateInfo;
import com.foxinmy.weixin4j.model.card.MemberUserForm;
import com.foxinmy.weixin4j.model.card.MemberUserInfo;
import com.foxinmy.weixin4j.model.qr.QRParameter;
import com.foxinmy.weixin4j.model.qr.QRResult;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.card.CardStatus;
import com.foxinmy.weixin4j.type.card.CardType;
import com.foxinmy.weixin4j.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class CardApi
extends MpApi {
    protected final TokenManager tokenManager;

    public CardApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String createCardCoupon(CardCoupon cardCoupon) throws WeixinException {
        JSONObject content = new JSONObject();
        String cardType = cardCoupon.getCardType().name();
        content.put("card_type", (Object)cardType);
        content.put(cardType.toLowerCase(), (Object)cardCoupon);
        JSONObject card = new JSONObject();
        card.put("card", (Object)content);
        Token token = (Token)this.tokenManager.getCache();
        String card_create_uri = this.getRequestUri("card_create_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(card_create_uri, token.getAccessToken()), card.toJSONString());
        return response.getAsJson().getString("card_id");
    }

    public ApiResult setCardPayCell(String cardId, boolean isOpen) throws WeixinException {
        JSONObject params = new JSONObject();
        params.put("card_id", (Object)cardId);
        params.put("is_open", (Object)isOpen);
        Token token = (Token)this.tokenManager.getCache();
        String card_paycell_uri = this.getRequestUri("card_paycell_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(card_paycell_uri, token.getAccessToken()), params.toJSONString());
        return response.getAsResult();
    }

    public ApiResult setCardSelfConsumeCell(String cardId, boolean isOpen) throws WeixinException {
        JSONObject params = new JSONObject();
        params.put("card_id", (Object)cardId);
        params.put("is_open", (Object)isOpen);
        Token token = (Token)this.tokenManager.getCache();
        String card_selfconsumecell_uri = this.getRequestUri("card_selfconsumecell_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(card_selfconsumecell_uri, token.getAccessToken()), params.toJSONString());
        return response.getAsResult();
    }

    public QRResult createCardQR(Integer expireSeconds, CardQR ... cardQRs) throws WeixinException {
        QRParameter parameter = QRParameter.createCardCouponQR((Integer)expireSeconds, (CardQR[])cardQRs);
        Token token = (Token)this.tokenManager.getCache();
        String qr_uri = this.getRequestUri("card_qr_ticket_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(qr_uri, token.getAccessToken()), JSON.toJSONString((Object)parameter));
        QRResult result = (QRResult)response.getAsObject((TypeReference)new TypeReference<QRResult>(){});
        qr_uri = String.format(this.getRequestUri("qr_image_uri"), result.getTicket());
        response = this.weixinExecutor.get(qr_uri, new URLParameter[0]);
        result.setShowUrl(qr_uri);
        try {
            result.setContent(IOUtil.toByteArray((InputStream)response.getBody()));
        }
        catch (IOException e) {
            throw new WeixinException((Throwable)e);
        }
        return result;
    }

    public ApiResult setTestWhiteList(List<String> openIds, List<String> userNames) throws WeixinException {
        JSONObject requestObj = new JSONObject();
        if (openIds != null && openIds.size() > 0) {
            requestObj.put("openid", openIds);
        }
        if (userNames != null && userNames.size() > 0) {
            requestObj.put("username", userNames);
        }
        String card_set_test_whitelist_uri = this.getRequestUri("card_set_test_whitelist_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(card_set_test_whitelist_uri, token.getAccessToken()), requestObj.toJSONString());
        return response.getAsResult();
    }

    public CardStatus queryCardStatus(String cardId) throws WeixinException {
        JSONObject requestObj = new JSONObject();
        requestObj.put("card_id", (Object)cardId);
        String card_get_uri = this.getRequestUri("card_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(card_get_uri, token.getAccessToken()), requestObj.toJSONString());
        JSONObject responseAsJson = response.getAsJson();
        JSONObject card = responseAsJson.getJSONObject("card");
        String cardType = card.getString("card_type");
        JSONObject baseInfo = card.getJSONObject(cardType.toLowerCase()).getJSONObject("base_info");
        String status = baseInfo.getString("status");
        return CardStatus.valueOf((String)status);
    }

    public Boolean updateCardCoupon(String cardId, CardCoupon card) throws WeixinException {
        JSONObject request = new JSONObject();
        request.put("card_id", (Object)cardId);
        CardType cardType = card.getCardType();
        card.cleanCantUpdateField();
        request.put(cardType.name().toLowerCase(), (Object)card);
        String card_update_uri = this.getRequestUri("card_update_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(card_update_uri, token.getAccessToken()), JSON.toJSONString((Object)request));
        JSONObject jsonObject = response.getAsJson();
        return jsonObject.getBoolean("send_check");
    }

    public ApiResult activateMemberCard(MemberInitInfo memberInitInfo) throws WeixinException {
        String card_member_card_activate_uri = this.getRequestUri("card_member_card_activate_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(card_member_card_activate_uri, token.getAccessToken()), JSON.toJSONString((Object)memberInitInfo));
        return response.getAsResult();
    }

    public ApiResult setActivateUserForm(MemberUserForm memberUserForm) throws WeixinException {
        String user_form_uri = this.getRequestUri("card_member_card_activate_user_form_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(user_form_uri, token.getAccessToken()), JSON.toJSONString((Object)memberUserForm));
        return response.getAsResult();
    }

    public MemberUserInfo getMemberUserInfo(String cardId, String code) throws WeixinException {
        String user_info_uri = this.getRequestUri("card_member_card_user_info_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("card_id", (Object)cardId);
        jsonObject.put("code", (Object)code);
        WeixinResponse response = this.weixinExecutor.post(String.format(user_info_uri, token.getAccessToken()), JSON.toJSONString((Object)jsonObject));
        return (MemberUserInfo)response.getAsObject((TypeReference)new TypeReference<MemberUserInfo>(){});
    }

    public JSONObject updateMemberUserInfo(MemberUpdateInfo updateInfo) throws WeixinException {
        String card_member_card_update_user_uri = this.getRequestUri("card_member_card_update_user_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(card_member_card_update_user_uri, token.getAccessToken()), JSON.toJSONString((Object)updateInfo));
        return response.getAsJson();
    }
}

