/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.type.DatacubeType;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DataApi
extends MpApi {
    private final TokenManager tokenManager;

    public DataApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public List<?> datacube(DatacubeType datacubeType, Date beginDate, int offset) throws WeixinException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginDate);
        ca.add(5, offset);
        return this.datacube(datacubeType, beginDate, ca.getTime());
    }

    public List<?> datacube(DatacubeType datacubeType, int offset, Date endDate) throws WeixinException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(5, 0 - offset);
        return this.datacube(datacubeType, ca.getTime(), endDate);
    }

    public List<?> datacube(DatacubeType datacubeType, Date date) throws WeixinException {
        return this.datacube(datacubeType, date, date);
    }

    public List<?> datacube(DatacubeType datacubeType, Date beginDate, Date endDate) throws WeixinException {
        String datacube_uri = this.getRequestUri("datacube_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("begin_date", (Object)DateUtil.fortmat2yyyy_MM_dd((Date)beginDate));
        obj.put("end_date", (Object)DateUtil.fortmat2yyyy_MM_dd((Date)endDate));
        WeixinResponse response = this.weixinExecutor.post(String.format(datacube_uri, datacubeType.name().toLowerCase(), token.getAccessToken()), obj.toJSONString());
        return JSON.parseArray((String)response.getAsJson().getString("list"), datacubeType.getClazz());
    }
}

