/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.qr.QRParameter;
import com.foxinmy.weixin4j.model.qr.QRResult;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;

public class QrApi
extends MpApi {
    private final TokenManager tokenManager;

    public QrApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public QRResult createQR(QRParameter parameter) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String qr_uri = this.getRequestUri("qr_ticket_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(qr_uri, token.getAccessToken()), JSON.toJSONString((Object)parameter));
        QRResult result = (QRResult)response.getAsObject((TypeReference)new TypeReference<QRResult>(){});
        qr_uri = String.format(this.getRequestUri("qr_image_uri"), result.getTicket());
        response = this.weixinExecutor.get(qr_uri, new URLParameter[0]);
        result.setShowUrl(qr_uri);
        try {
            result.setContent(IOUtil.toByteArray((InputStream)response.getBody()));
        }
        catch (IOException e) {
            throw new WeixinException((Throwable)e);
        }
        return result;
    }
}

