/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.api.UserApi;
import com.foxinmy.weixin4j.mp.model.Following;
import com.foxinmy.weixin4j.mp.model.Tag;
import com.foxinmy.weixin4j.mp.model.User;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.ArrayList;
import java.util.List;

public class TagApi
extends MpApi {
    private final TokenManager tokenManager;
    private final UserApi userApi;

    public TagApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.userApi = new UserApi(tokenManager);
    }

    public Tag createTag(String name) throws WeixinException {
        String tag_create_uri = this.getRequestUri("tag_create_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_create_uri, this.tokenManager.getAccessToken()), String.format("{\"tag\":{\"name\":\"%s\"}}", name));
        JSONObject obj = response.getAsJson().getJSONObject("tag");
        return new Tag(obj.getIntValue("id"), obj.getString("name"));
    }

    public List<Tag> listTags() throws WeixinException {
        String tag_get_uri = this.getRequestUri("tag_get_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(tag_get_uri, this.tokenManager.getAccessToken()), new URLParameter[0]);
        return JSON.parseArray((String)response.getAsJson().getString("tags"), Tag.class);
    }

    public ApiResult updateTag(Tag tag) throws WeixinException {
        String tag_update_uri = this.getRequestUri("tag_update_uri");
        JSONObject obj = new JSONObject();
        obj.put("tag", (Object)tag);
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_update_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult deleteTag(int tagId) throws WeixinException {
        String tag_delete_uri = this.getRequestUri("tag_delete_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_delete_uri, this.tokenManager.getAccessToken()), String.format("{\"tag\":{\"id\":%d}}", tagId));
        return response.getAsResult();
    }

    public ApiResult taggingUsers(int tagId, String ... openIds) throws WeixinException {
        return this.batchUsers("tag_tagging_uri", tagId, openIds);
    }

    private ApiResult batchUsers(String batchType, int tagId, String ... openIds) throws WeixinException {
        String tag_batch_uri = this.getRequestUri(batchType);
        JSONObject obj = new JSONObject();
        obj.put("openid_list", (Object)openIds);
        obj.put("tagid", (Object)tagId);
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_batch_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult untaggingUsers(int tagId, String ... openIds) throws WeixinException {
        return this.batchUsers("tag_untagging_uri", tagId, openIds);
    }

    public Following getTagFollowingOpenIds(int tagId, String nextOpenId) throws WeixinException {
        String tag_user_uri = this.getRequestUri("tag_user_uri");
        JSONObject obj = new JSONObject();
        obj.put("tagid", (Object)tagId);
        obj.put("next_openid", (Object)nextOpenId);
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_user_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        JSONObject result = response.getAsJson();
        Following following = (Following)JSON.toJavaObject((JSON)result, Following.class);
        if (following.getCount() > 0) {
            following.setOpenIds(JSON.parseArray((String)result.getJSONObject("data").getString("openid"), String.class));
        }
        return following;
    }

    public Following getTagFollowing(int tagId, String nextOpenId) throws WeixinException {
        Following following = this.getTagFollowingOpenIds(tagId, nextOpenId);
        if (following.getCount() > 0) {
            ArrayList<User> users = new ArrayList<User>(following.getCount());
            for (int i = 1; i <= (int)Math.ceil((double)following.getCount() / 100.0); ++i) {
                users.addAll(this.userApi.getUsers(following.getOpenIds().subList((i - 1) * 100, Math.min(i * 100, following.getCount())).toArray(new String[0])));
            }
            following.setUserList(users);
        }
        return following;
    }

    public List<String> getAllTagFollowingOpenIds(int tagId) throws WeixinException {
        ArrayList<String> openIds = new ArrayList<String>();
        String nextOpenId = null;
        Following f = null;
        while ((f = this.getTagFollowingOpenIds(tagId, nextOpenId)).hasContent()) {
            openIds.addAll(f.getOpenIds());
            nextOpenId = f.getNextOpenId();
        }
        return openIds;
    }

    public List<User> getAllTagFollowing(int tagId) throws WeixinException {
        ArrayList<User> userList = new ArrayList<User>();
        String nextOpenId = null;
        Following f = null;
        while ((f = this.getTagFollowing(tagId, nextOpenId)).hasContent()) {
            userList.addAll(f.getUserList());
            nextOpenId = f.getNextOpenId();
        }
        return userList;
    }

    public Integer[] getUserTags(String openId) throws WeixinException {
        String tag_userids_uri = this.getRequestUri("tag_userids_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_userids_uri, this.tokenManager.getAccessToken()), String.format("{\"openid\":\"%s\"}", openId));
        return (Integer[])response.getAsJson().getJSONArray("tagid_list").toArray((Object[])new Integer[0]);
    }

    public Following getBalcklistOpenIds(String nextOpenId) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("begin_openid", (Object)(nextOpenId == null ? "" : nextOpenId));
        String getblacklist_uri = this.getRequestUri("getblacklist_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(getblacklist_uri, token.getAccessToken(), obj.toJSONString()), new FormBodyPart[0]);
        JSONObject result = response.getAsJson();
        Following following = (Following)JSON.toJavaObject((JSON)result, Following.class);
        if (following.getCount() > 0) {
            following.setOpenIds(JSON.parseArray((String)result.getJSONObject("data").getString("openid"), String.class));
        }
        return following;
    }

    public List<String> getAllBalcklistOpenIds() throws WeixinException {
        ArrayList<String> openIds = new ArrayList<String>();
        String nextOpenId = null;
        Following f = null;
        while ((f = this.getBalcklistOpenIds(nextOpenId)).hasContent()) {
            openIds.addAll(f.getOpenIds());
            nextOpenId = f.getNextOpenId();
        }
        return openIds;
    }

    public ApiResult batchBlacklist(boolean blacklist, String ... openIds) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("openid_list", (Object)openIds);
        String blacklist_url = blacklist ? this.getRequestUri("batchblacklist_uri") : this.getRequestUri("batchunblacklist_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(blacklist_url, this.tokenManager.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }
}

