/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.social;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.fujieid.jap.core.exception.JapSocialException;
import com.fujieid.jap.social.SocialConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.request.AuthRequest;

public class JustAuthRequestContext {
    private static final Log log = LogFactory.get();
    private static final Map<String, Class<?>> AUTH_REQUEST_HOLDER = new HashMap(8);
    private static final String REGEX = "Auth([\\w]+)Request";
    private static final String DEFAULT_SCAN_PACKAGES = "me.zhyd.oauth.request";
    private static final String[] DEFAULT_EXCLUSION_CLASS_NAMES = new String[]{"AuthDefaultRequest", "AbstractAuthWeChatEnterpriseRequest", "AuthRequest"};
    private static boolean isLoaded = false;

    public static void register(String source, AuthRequest authRequest) {
        if (StrUtil.isBlank((CharSequence)source) || ObjectUtil.isNull((Object)authRequest)) {
            return;
        }
        AUTH_REQUEST_HOLDER.put(source.toUpperCase(), authRequest.getClass());
        log.debug("The AuthRequest implementation class [{}] has been registered, and the platform is named [{}]...", new Object[]{authRequest.getClass().getName(), source});
    }

    private static void loadRequest(String[] scanPackages, String[] exclusionClassNames) {
        if (isLoaded) {
            return;
        }
        JustAuthRequestContext.scanPackage(DEFAULT_SCAN_PACKAGES, DEFAULT_EXCLUSION_CLASS_NAMES);
        if (ArrayUtil.isNotEmpty((Object[])scanPackages)) {
            for (String scanPackage : scanPackages) {
                JustAuthRequestContext.scanPackage(scanPackage, exclusionClassNames);
            }
        }
        isLoaded = true;
        log.debug("AuthRequest scan completed, a total of {} class files were scanned...", new Object[]{AUTH_REQUEST_HOLDER.size()});
    }

    private static void scanPackage(String scanPackage, String[] exclusionClassNames) {
        log.debug("Start scanning package path {}...", new Object[]{scanPackage});
        Set classes = ClassUtil.scanPackage((String)scanPackage);
        HashMap<String, Class> item = new HashMap<String, Class>(16);
        for (Class clazz : classes) {
            String source;
            String className = ClassUtil.getClassName((Class)clazz, (boolean)true);
            if (Arrays.asList(exclusionClassNames).contains(className) || StrUtil.isBlank((CharSequence)(source = ReUtil.get((String)REGEX, (CharSequence)className, (int)1)))) continue;
            source = JustAuthRequestContext.getRealSource(source);
            log.debug("The file {} is scanned successfully under the package path {}, and the platform name is {}....", new Object[]{className, scanPackage, source});
            item.put(source.toUpperCase(), clazz);
        }
        AUTH_REQUEST_HOLDER.putAll(item);
        log.debug("A total of {} class files are scanned under the package path {}...", new Object[]{item.size(), scanPackage});
    }

    private static String getRealSource(String source) {
        switch (source) {
            case "WeChatOpen": {
                source = "WECHAT_OPEN";
                break;
            }
            case "WeChatMp": {
                source = "WECHAT_MP";
                break;
            }
            case "StackOverflow": {
                source = "STACK_OVERFLOW";
                break;
            }
            case "WeChatEnterpriseQrcode": {
                source = "WECHAT_ENTERPRISE";
                break;
            }
            case "WeChatEnterpriseWeb": {
                source = "WECHAT_ENTERPRISE_WEB";
                break;
            }
        }
        return source;
    }

    public static void clearContext() {
        AUTH_REQUEST_HOLDER.clear();
    }

    public static AuthRequest getRequest(String source, SocialConfig socialConfig, AuthConfig authConfig, AuthStateCache stateCache) throws JapSocialException {
        if (StrUtil.isBlank((CharSequence)source)) {
            throw new JapSocialException("Social#Missing social source");
        }
        JustAuthRequestContext.loadRequest(socialConfig.getScanPackages(), socialConfig.getExclusionClassNames());
        Class<?> clazz = AUTH_REQUEST_HOLDER.get(source.toUpperCase());
        if (ObjectUtil.isNull(clazz)) {
            throw new JapSocialException("Social#Current source is not supported. ".concat(source));
        }
        if (ObjectUtil.isNull((Object)authConfig)) {
            throw new JapSocialException("Social#Missing AuthConfig.");
        }
        if (ObjectUtil.isNull((Object)stateCache)) {
            return (AuthRequest)ReflectUtil.newInstance(clazz, (Object[])new Object[]{authConfig});
        }
        return (AuthRequest)ReflectUtil.newInstance(clazz, (Object[])new Object[]{authConfig, stateCache});
    }
}

