/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.social;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.JapUserService;
import com.fujieid.jap.core.cache.JapCache;
import com.fujieid.jap.core.config.AuthenticateConfig;
import com.fujieid.jap.core.config.JapConfig;
import com.fujieid.jap.core.exception.JapException;
import com.fujieid.jap.core.exception.JapSocialException;
import com.fujieid.jap.core.exception.JapUserException;
import com.fujieid.jap.core.result.JapErrorCode;
import com.fujieid.jap.core.result.JapResponse;
import com.fujieid.jap.core.strategy.AbstractJapStrategy;
import com.fujieid.jap.social.JustAuthRequestContext;
import com.fujieid.jap.social.SocialConfig;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;

public class SocialStrategy
extends AbstractJapStrategy {
    private AuthStateCache authStateCache;

    public SocialStrategy(JapUserService japUserService, JapConfig japConfig) {
        super(japUserService, japConfig);
    }

    public SocialStrategy(JapUserService japUserService, JapConfig japConfig, JapCache japCache) {
        super(japUserService, japConfig, japCache);
    }

    public SocialStrategy(JapUserService japUserService, JapConfig japConfig, AuthStateCache authStateCache) {
        this(japUserService, japConfig);
        this.authStateCache = authStateCache;
    }

    public SocialStrategy(JapUserService japUserService, JapConfig japConfig, JapCache japCache, AuthStateCache authStateCache) {
        this(japUserService, japConfig, japCache);
        this.authStateCache = authStateCache;
    }

    public JapResponse authenticate(AuthenticateConfig config, HttpServletRequest request, HttpServletResponse response) {
        JapUser sessionUser = this.checkSession(request, response);
        if (null != sessionUser) {
            return JapResponse.success((Object)sessionUser);
        }
        AuthRequest authRequest = null;
        try {
            authRequest = this.getAuthRequest(config);
        }
        catch (JapException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        SocialConfig socialConfig = (SocialConfig)config;
        String source = socialConfig.getPlatform();
        AuthCallback authCallback = this.parseRequest(request);
        if (!this.isCallback(source, authCallback)) {
            String url = authRequest.authorize(socialConfig.getState());
            return JapResponse.success((Object)url);
        }
        try {
            return this.login(request, response, source, authRequest, authCallback);
        }
        catch (JapUserException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
    }

    public JapResponse refreshToken(AuthenticateConfig config, AuthToken authToken) {
        AuthRequest authRequest = null;
        try {
            authRequest = this.getAuthRequest(config);
        }
        catch (JapException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        SocialConfig socialConfig = (SocialConfig)config;
        String source = socialConfig.getPlatform();
        AuthResponse authUserAuthResponse = null;
        try {
            authUserAuthResponse = authRequest.refresh(authToken);
        }
        catch (Exception e) {
            throw new JapSocialException("Third party refresh access token of `" + source + "` failed. " + e.getMessage());
        }
        if (!authUserAuthResponse.ok() || ObjectUtil.isNull((Object)authUserAuthResponse.getData())) {
            throw new JapUserException("Third party refresh access token of `" + source + "` failed. " + authUserAuthResponse.getMsg());
        }
        authToken = (AuthToken)authUserAuthResponse.getData();
        return JapResponse.success((Object)authToken);
    }

    public JapResponse revokeToken(AuthenticateConfig config, AuthToken authToken) {
        AuthRequest authRequest = null;
        try {
            authRequest = this.getAuthRequest(config);
        }
        catch (JapException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        SocialConfig socialConfig = (SocialConfig)config;
        String source = socialConfig.getPlatform();
        AuthResponse authUserAuthResponse = null;
        try {
            authUserAuthResponse = authRequest.revoke(authToken);
        }
        catch (Exception e) {
            throw new JapSocialException("Third party refresh access token of `" + source + "` failed. " + e.getMessage());
        }
        if (!authUserAuthResponse.ok() || ObjectUtil.isNull((Object)authUserAuthResponse.getData())) {
            throw new JapUserException("Third party refresh access token of `" + source + "` failed. " + authUserAuthResponse.getMsg());
        }
        return JapResponse.success();
    }

    public JapResponse getUserInfo(AuthenticateConfig config, AuthToken authToken) {
        AuthRequest authRequest = null;
        try {
            authRequest = this.getAuthRequest(config);
        }
        catch (JapException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        SocialConfig socialConfig = (SocialConfig)config;
        String source = socialConfig.getPlatform();
        String funName = "getUserInfo";
        Method method = null;
        AuthUser res = null;
        JapUserException japUserException = new JapUserException("Failed to obtain user information on the third-party platform `" + source + "`");
        try {
            method = ReflectUtil.getMethod(authRequest.getClass(), (String)funName, (Class[])new Class[]{AuthToken.class});
            if (method != null) {
                method.setAccessible(true);
                res = (AuthUser)ReflectUtil.invoke((Object)authRequest, (Method)method, (Object[])new Object[]{authToken});
                if (null == res) {
                    throw japUserException;
                }
            }
        }
        catch (Exception e) {
            throw japUserException;
        }
        AuthUser authUser = res;
        return JapResponse.success(authUser);
    }

    private AuthRequest getAuthRequest(AuthenticateConfig config) {
        this.checkAuthenticateConfig(config, SocialConfig.class);
        SocialConfig socialConfig = (SocialConfig)config;
        String source = socialConfig.getPlatform();
        AuthConfig authConfig = socialConfig.getJustAuthConfig();
        if (ObjectUtil.isNull((Object)authConfig)) {
            throw new JapException(JapErrorCode.MISS_AUTH_CONFIG);
        }
        return JustAuthRequestContext.getRequest(source, socialConfig, authConfig, this.authStateCache);
    }

    private JapResponse login(HttpServletRequest request, HttpServletResponse response, String source, AuthRequest authRequest, AuthCallback authCallback) throws JapUserException {
        AuthResponse authUserAuthResponse = null;
        try {
            authUserAuthResponse = authRequest.login(authCallback);
        }
        catch (Exception e) {
            throw new JapSocialException("Third party login of `" + source + "` failed. " + e.getMessage());
        }
        if (!authUserAuthResponse.ok() || ObjectUtil.isNull((Object)authUserAuthResponse.getData())) {
            throw new JapUserException("Third party login of `" + source + "` cannot obtain user information. " + authUserAuthResponse.getMsg());
        }
        AuthUser socialUser = (AuthUser)authUserAuthResponse.getData();
        JapUser japUser = this.japUserService.getByPlatformAndUid(source, socialUser.getUuid());
        if (ObjectUtil.isNull((Object)japUser) && ObjectUtil.isNull((Object)(japUser = this.japUserService.createAndGetSocialUser((Object)socialUser)))) {
            throw new JapUserException("Unable to save user information of " + source);
        }
        return this.loginSuccess(japUser, request, response);
    }

    private boolean isCallback(String source, AuthCallback authCallback) {
        if (source.equals(AuthDefaultSource.TWITTER.name()) && ObjectUtil.isNotNull((Object)authCallback.getOauth_token())) {
            return true;
        }
        String code = authCallback.getCode();
        if (source.equals(AuthDefaultSource.ALIPAY.name())) {
            code = authCallback.getAuth_code();
        } else if (source.equals(AuthDefaultSource.HUAWEI.name())) {
            code = authCallback.getAuthorization_code();
        }
        return !StrUtil.isEmpty((CharSequence)code);
    }

    private AuthCallback parseRequest(HttpServletRequest request) {
        Map params = request.getParameterMap();
        if (CollectionUtil.isEmpty((Map)params)) {
            return new AuthCallback();
        }
        JSONObject jsonObject = new JSONObject();
        params.forEach((key, val) -> {
            if (ObjectUtil.isNotNull((Object)val)) {
                jsonObject.put(key, (Object)val[0]);
            }
        });
        return (AuthCallback)jsonObject.toJavaObject(AuthCallback.class);
    }
}

