/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.datasource;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dao.DatasourceDao;
import com.gccloud.dataset.entity.DatasourceEntity;
import com.gccloud.dataset.service.IBaseDatasourceService;
import com.gccloud.dataset.utils.DBUtils;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DbDataVO;
import com.gccloud.dataset.vo.FieldInfoVO;
import com.gccloud.dataset.vo.TableInfoVO;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="oracle")
public class OracleDatasourceServiceImpl
extends ServiceImpl<DatasourceDao, DatasourceEntity>
implements IBaseDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(OracleDatasourceServiceImpl.class);
    private static final List<String> ORACLE_DATA_TYPE = Lists.newArrayList((Object[])new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TIMEZONE_REGION", "TIMEZONE_ABBR", "DATE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "INTERVAL YEAR TO MONTH", "INTERVAL DAY TO SECOND"});
    private static final List<String> ORACLE_NUMBER_TYPE = Lists.newArrayList((Object[])new String[]{"NUMBER", "FLOAT", "BINARY_FLOAT", "BINARY_DOUBLE"});

    @Override
    public DataVO executeSql(DatasourceEntity datasource, String sql) {
        DbDataVO dbDataVO = DBUtils.getSqlValue(sql, datasource);
        DBUtils.unityDataType(dbDataVO.getData(), dbDataVO.getStructure(), ORACLE_NUMBER_TYPE, ORACLE_DATA_TYPE);
        return new DataVO(dbDataVO.getData(), dbDataVO.getStructure());
    }

    @Override
    public DataVO executeSqlPage(DatasourceEntity datasource, String sql, Integer current, Integer size) {
        String tmpColumnStr;
        String columnStr;
        List<String> columns;
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String countSql = "SELECT COUNT(1) AS COUNT FROM (" + sql + ")";
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u8ba1\u7b97\u603b\u6761\u6570 sql\u8bed\u53e5\uff1a{}", (Object)countSql);
        DbDataVO countData = DBUtils.getSqlValue(countSql, datasource);
        Object count = countData.getData().get(0).get("COUNT");
        int total = Integer.parseInt(count.toString());
        int start = (current - 1) * size;
        int end = current * size;
        if (end > total) {
            end = total;
        }
        if ((columns = DBUtils.getColumns(sql, datasource.getSourceType())) == null || columns.size() == 0 || columns.contains("*")) {
            columnStr = "*";
            tmpColumnStr = "TMP.*";
        } else {
            columnStr = String.join((CharSequence)",", columns);
            tmpColumnStr = "TMP." + String.join((CharSequence)",TMP.", columns);
        }
        String pageSql = "SELECT " + columnStr + " FROM ( SELECT " + tmpColumnStr + ", ROWNUM ROW_ID FROM ( " + sql + " ) TMP WHERE ROWNUM <=" + end + " ) WHERE ROW_ID > " + start;
        log.info("\u6570\u636e\u96c6\u6570\u636e\u8be6\u60c5\u5206\u9875 sql\u8bed\u53e5\uff1a{}", (Object)pageSql);
        DbDataVO pageData = DBUtils.getSqlValue(pageSql, datasource);
        PageVO page = new PageVO();
        page.setCurrent((long)current.intValue());
        page.setSize((long)size.intValue());
        page.setTotalCount((long)total);
        page.setTotalPage((long)((total + size - 1) / size));
        page.setList(pageData.getData());
        DBUtils.unityDataType(pageData.getData(), pageData.getStructure(), ORACLE_NUMBER_TYPE, ORACLE_DATA_TYPE);
        return new DataVO(page, pageData.getStructure());
    }

    @Override
    public DataVO executeProcedure(DatasourceEntity datasource, String procedure, Integer current, Integer size) {
        boolean pageFlag;
        if (!procedure.startsWith("{") && !procedure.endsWith("}")) {
            procedure = "{" + procedure + "}";
        }
        DbDataVO call = DBUtils.call(procedure, datasource, current, size);
        DBUtils.unityDataType(call.getData(), call.getStructure(), ORACLE_NUMBER_TYPE, ORACLE_DATA_TYPE);
        boolean bl = pageFlag = current != null && size != null;
        if (pageFlag) {
            return new DataVO(call.getPageData(), call.getStructure());
        }
        return new DataVO(call.getData(), call.getStructure());
    }

    @Override
    public List<TableInfoVO> getTableList(DatasourceEntity datasource) {
        String sql = " SELECT TABLE_NAME FROM USER_TABLES ORDER BY TABLE_NAME ";
        DbDataVO dataVO = DBUtils.getSqlValue(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableList = Lists.newArrayList();
        if (data == null || data.size() == 0) {
            return tableList;
        }
        for (Map<String, Object> map : data) {
            TableInfoVO tableInfoVO = new TableInfoVO();
            tableInfoVO.setName(map.get("TABLE_NAME").toString());
            tableInfoVO.setStatus(0);
            tableList.add(tableInfoVO);
        }
        return tableList;
    }

    @Override
    public List<FieldInfoVO> getTableColumnList(DatasourceEntity datasource, String tableName) {
        Connection conn = DBUtils.getConnection(datasource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList columnList = Lists.newArrayList();
        try {
            String sql = "select * from " + tableName + " where ROWNUM = 0";
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            String commentSql = "SELECT a.column_name,b.comments FROM user_tab_columns a, user_col_comments b WHERE a.table_name = '" + tableName + "' and b.table_name = '" + tableName + "' and a.column_name = b.column_name";
            PreparedStatement commentPs = conn.prepareStatement(commentSql);
            ResultSet commentRs = commentPs.executeQuery();
            HashMap<String, String> commentMap = new HashMap<String, String>();
            while (commentRs.next()) {
                commentMap.put(commentRs.getString("COLUMN_NAME"), commentRs.getString("COMMENTS"));
            }
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                FieldInfoVO fieldInfoVO = new FieldInfoVO();
                fieldInfoVO.setColumnName(metaData.getColumnName(i));
                fieldInfoVO.setColumnType(metaData.getColumnTypeName(i));
                fieldInfoVO.setColumnComment((String)commentMap.get(metaData.getColumnName(i)));
                columnList.add(fieldInfoVO);
            }
            ArrayList arrayList = columnList;
            return arrayList;
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0ctableName\uff1a{}", (Object)tableName);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25");
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("\u6570\u636e\u6e90\u8fde\u63a5\u5173\u95ed\u5f02\u5e38,{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<TableInfoVO> getViewList(DatasourceEntity datasource) {
        String sql = "SELECT VIEW_NAME FROM USER_VIEWS ORDER BY VIEW_NAME";
        DbDataVO dataVO = DBUtils.getSqlValue(sql, datasource);
        List<Map<String, Object>> data = dataVO.getData();
        ArrayList tableList = Lists.newArrayList();
        if (data == null || data.size() == 0) {
            return tableList;
        }
        for (Map<String, Object> map : data) {
            TableInfoVO tableInfoVO = new TableInfoVO();
            tableInfoVO.setName(map.get("VIEW_NAME").toString());
            tableInfoVO.setStatus(0);
            tableList.add(tableInfoVO);
        }
        return tableList;
    }

    @Override
    public List<FieldInfoVO> getViewColumnList(DatasourceEntity datasource, String viewName) {
        return this.getTableColumnList(datasource, viewName);
    }
}

