/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.label;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dao.LabelDao;
import com.gccloud.dataset.dto.LabelDTO;
import com.gccloud.dataset.dto.LabelSearchDTO;
import com.gccloud.dataset.entity.DatasetLabelEntity;
import com.gccloud.dataset.entity.LabelEntity;
import com.gccloud.dataset.service.IDatasetLabelService;
import com.gccloud.dataset.service.ILabelService;
import com.gccloud.dataset.vo.DatasetLabelVO;
import com.gccloud.dataset.vo.LabelVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LabelServiceImpl
extends ServiceImpl<LabelDao, LabelEntity>
implements ILabelService {
    @Resource
    private IDatasetLabelService datasetLabelService;

    @Override
    public PageVO<LabelEntity> getPage(LabelSearchDTO searchDTO) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getLabelName()), LabelEntity::getLabelName, (Object)searchDTO.getLabelName());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getLabelType()), LabelEntity::getLabelType, (Object)searchDTO.getLabelType());
        wrapper.select((Object[])new SFunction[]{SuperEntity::getId, LabelEntity::getLabelName, LabelEntity::getLabelType, LabelEntity::getLabelDesc});
        wrapper.orderByDesc(SuperEntity::getCreateDate);
        return this.page(searchDTO, wrapper);
    }

    @Override
    public String add(LabelDTO labelDTO) {
        LabelEntity labelEntity = (LabelEntity)((Object)BeanConvertUtils.convert((Object)labelDTO, LabelEntity.class));
        boolean repeat = this.checkRepeat(labelEntity);
        if (repeat) {
            throw new GlobalException("\u6807\u7b7e\u540d\u79f0\u91cd\u590d");
        }
        this.save((Object)labelEntity);
        return labelEntity.getId();
    }

    @Override
    public void update(LabelDTO labelDTO) {
        LabelEntity labelEntity = (LabelEntity)((Object)BeanConvertUtils.convert((Object)labelDTO, LabelEntity.class));
        boolean repeat = this.checkRepeat(labelEntity);
        if (repeat) {
            throw new GlobalException("\u6807\u7b7e\u540d\u79f0\u91cd\u590d");
        }
        this.updateById((Object)labelEntity);
    }

    @Override
    public void delete(String id) {
        this.datasetLabelService.deleteByLabelId(id);
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public LabelVO getInfoById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LabelEntity labelEntity = (LabelEntity)((Object)this.getById((Serializable)((Object)id)));
        if (labelEntity == null) {
            throw new GlobalException("\u6807\u7b7e\u4e0d\u5b58\u5728");
        }
        List<DatasetLabelVO> dataSetList = this.datasetLabelService.getDatasetByLabelId(id);
        int y = 100;
        if (!CollectionUtils.isEmpty(dataSetList)) {
            y = dataSetList.size() % 2 == 0 ? 100 * (dataSetList.size() / 2 + 1) - 50 : 100 * (dataSetList.size() / 2 + 1);
        }
        HashMap<String, Object> dataSetMap = new HashMap<String, Object>();
        ArrayList nodeList = new ArrayList(16);
        ArrayList edgeList = new ArrayList(16);
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        nodeMap.put("id", labelEntity.getId() + "_node");
        nodeMap.put("x", 400);
        nodeMap.put("y", y);
        nodeMap.put("class", "c3");
        nodeMap.put("label", labelEntity.getLabelName());
        nodeList.add(nodeMap);
        dataSetMap.put("nodes", nodeList);
        dataSetMap.put("edges", edgeList);
        LabelVO labelVO = (LabelVO)((Object)BeanConvertUtils.convert((Object)((Object)labelEntity), LabelVO.class));
        labelVO.setJsonData(dataSetMap);
        if (CollectionUtils.isEmpty(dataSetList)) {
            return labelVO;
        }
        int count = 1;
        for (DatasetLabelVO datasetLabelVO : dataSetList) {
            HashMap<String, Object> dataSetNodeMap = new HashMap<String, Object>();
            dataSetNodeMap.put("id", datasetLabelVO.getId());
            dataSetNodeMap.put("x", 800);
            dataSetNodeMap.put("y", count * 100);
            dataSetNodeMap.put("label", datasetLabelVO.getName());
            nodeList.add(dataSetNodeMap);
            ++count;
            HashMap<String, String> edgeMap = new HashMap<String, String>();
            edgeMap.put("source", labelEntity.getId() + "_node");
            edgeMap.put("target", datasetLabelVO.getId());
            edgeList.add(edgeMap);
        }
        return labelVO;
    }

    @Override
    public boolean checkRepeat(LabelEntity labelEntity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        wrapper.eq(LabelEntity::getLabelName, (Object)labelEntity.getLabelName());
        wrapper.ne(StringUtils.isNotBlank((CharSequence)labelEntity.getId()), SuperEntity::getId, (Object)labelEntity.getId());
        return this.list((Wrapper)wrapper).size() > 0;
    }

    @Override
    public List<String> getLabelType() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{LabelEntity::getLabelType});
        wrapper.isNotNull(LabelEntity::getLabelType);
        wrapper.groupBy(LabelEntity::getLabelType);
        return this.list((Wrapper)wrapper).stream().map(LabelEntity::getLabelType).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public void deleteLabelByType(String labelType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LabelEntity::getLabelType, (Object)labelType);
        List list = this.list((Wrapper)wrapper);
        List idList = list.stream().map(SuperEntity::getId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return;
        }
        LambdaQueryWrapper datasetLabelWrapper = new LambdaQueryWrapper();
        datasetLabelWrapper.select((Object[])new SFunction[]{DatasetLabelEntity::getLabelId});
        datasetLabelWrapper.in(DatasetLabelEntity::getLabelId, idList);
        if (this.datasetLabelService.list((Wrapper)datasetLabelWrapper).size() > 0) {
            throw new GlobalException("\u8be5\u6807\u7b7e\u7c7b\u578b\u4e0b\u5b58\u5728\u6570\u636e\u96c6\u4e0e\u6807\u7b7e\u7684\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.removeByIds(idList);
    }

    @Override
    public void updateLabelType(String newLabelType, String oldLabelType) {
        if (newLabelType.equals(oldLabelType)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        wrapper.eq(LabelEntity::getLabelType, (Object)newLabelType);
        wrapper.ne(LabelEntity::getLabelType, (Object)oldLabelType);
        if (this.list((Wrapper)wrapper).size() > 0) {
            throw new GlobalException("\u6807\u7b7e\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(LabelEntity::getLabelType, (Object)newLabelType);
        updateWrapper.eq(LabelEntity::getLabelType, (Object)oldLabelType);
        this.update((Wrapper)updateWrapper);
    }
}

