/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.contant;

public enum HttpContentType {
    TEXT("text/plain;charset=utf-8"),
    HTML("text/html;charset=utf-8"),
    TEXT_XML("text/xml;charset=utf-8"),
    FORM("application/x-www-form-urlencoded;charset=utf-8"),
    MULTIPART("multipart/form-data"),
    SIGLE_OCSTREAM("application/octet-stream;charset=utf-8"),
    MULTI_OCSTREAM("application/octet-stream;charset=utf-8"),
    STREAM("application/octet-stream;charset=utf-8"),
    XML("application/xml;charset=utf-8"),
    JSON("application/json;charset=utf-8");

    private String value;

    private HttpContentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isStream(HttpContentType type) {
        if (type == null) {
            return false;
        }
        return type == SIGLE_OCSTREAM || type == MULTI_OCSTREAM || type == STREAM || type == MULTIPART;
    }

    public static boolean isForm(HttpContentType type) {
        if (type == null) {
            return false;
        }
        return type == FORM;
    }
}

