/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.sign;

import com.geely.gbop.api.GbopApiApp;
import com.geely.gbop.api.GbopApiRequest;
import com.geely.gbop.api.contant.HttpMethod;
import com.geely.gbop.api.sign.ISigner;
import com.geely.gbop.api.sign.SignMehod;
import com.geely.gbop.api.sign.SignUtil;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class HmacAuthSha512Sign
implements ISigner {
    public static final String METHOD = SignMehod.HmacSha512.getMethod();

    @Override
    public Object sign(GbopApiApp app, String host, HttpMethod method, GbopApiRequest apiRequest) {
        SignUtil.paddingHeader(app, host, apiRequest);
        apiRequest.getHeaders().put("X-Gapi-Ca-Algorithm", SignMehod.HmacSha512.getValue());
        apiRequest.getHeaders().put("X-Gapi-Ca-Signature", HmacAuthSha512Sign.toSign(app.getAppSecret(), method.getValue(), apiRequest.getPath(), apiRequest.getHeaders(), apiRequest.getParams()));
        return apiRequest.getHeaders();
    }

    public static String toSign(String secret, String method, String path, Map<String, String> headers, Map<String, Object> querys) {
        try {
            Mac hmacSha512 = Mac.getInstance(SignMehod.HmacSha512.getMethod());
            byte[] keyBytes = secret.getBytes("utf-8");
            hmacSha512.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, SignMehod.HmacSha512.getMethod()));
            return new String(Base64.encodeBase64((byte[])hmacSha512.doFinal(SignUtil.buildStringToSign(method, path, headers, querys).getBytes("utf-8"))), "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

