/*
 * Decompiled with CFR 0.152.
 */
package com.geely.gbop.api.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String writeValueAsString(Object obj) {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(String json, Class<?> parametrized, Class<?> parametersFor, Class<?> ... parameterClasses) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            JavaType javaType = JsonUtils.getCollectionType(parametrized, parametersFor, parameterClasses);
            return (T)MAPPER.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(String json, TypeReference<T> jsonTypeReference) {
        try {
            return (T)MAPPER.readValue(json, jsonTypeReference);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static JavaType getCollectionType(Class<?> parametrized, Class<?> parametersFor, Class<?> ... parameterClasses) {
        return TypeFactory.defaultInstance().constructParametrizedType(parametrized, parametersFor, (Class[])parameterClasses);
    }

    public static Map<String, JsonNode> parseJsonSchema(String jsonSchema) {
        HashMap<String, JsonNode> elementsMap = new HashMap<String, JsonNode>();
        try {
            JsonNode root = MAPPER.readTree(jsonSchema);
            JsonNode rootNode = root.path("properties");
            JsonUtils.FillTheElementMap(rootNode, elementsMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return elementsMap;
    }

    private static void FillTheElementMap(JsonNode rootNode, Map<String, JsonNode> elementsMap) {
        for (JsonNode cNode : rootNode) {
            if (cNode.path("type").toString().toLowerCase().contains("array")) {
                for (JsonNode ccNode : cNode.path("items")) {
                    JsonUtils.FillTheElementMap(ccNode, elementsMap);
                }
                continue;
            }
            if (cNode.path("type").toString().toLowerCase().contains("object")) {
                JsonUtils.FillTheElementMap(cNode.path("properties"), elementsMap);
                continue;
            }
            elementsMap.put(cNode.path("id").asText(), cNode);
        }
    }

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

