/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.common.http;

import com.getui.push.v2.sdk.GtHttpProxyConfig;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.Config;
import com.getui.push.v2.sdk.common.http.GtHttpDelete;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.dto.CommonEnum;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class GtHttpClient {
    private int maxHttpTryTime;
    CloseableHttpClient httpclient;

    public GtHttpClient(int connectTimeout, int soTimeout, int maxHttpTryTime, GtHttpProxyConfig proxyConfig) {
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("connectTimeout must be > 0.");
        }
        if (soTimeout <= 0) {
            throw new IllegalArgumentException("soTimeout must be > 0.");
        }
        this.maxHttpTryTime = maxHttpTryTime;
        HttpClientBuilder builder = HttpClients.custom();
        if (proxyConfig != null && Utils.isNotEmpty(proxyConfig.getHost())) {
            if (Utils.isNotEmpty(proxyConfig.getUsername())) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyConfig.getHost(), proxyConfig.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfig.getUsername(), proxyConfig.getPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            builder.setProxy(new HttpHost(proxyConfig.getHost(), proxyConfig.getPort()));
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(soTimeout).setMaxRedirects(0).build();
        builder.setDefaultRequestConfig(config);
        this.httpclient = builder.build();
    }

    public String execute(String url, String method, Map<String, Object> headers, String body, String contentType) {
        HttpUriRequest request = this.genHttpUriRequest(url, method);
        if (Utils.isNotEmpty(headers)) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (Utils.isNotEmpty(body) && request instanceof HttpEntityEnclosingRequestBase) {
            StringEntity entity;
            if (Utils.isEmpty(contentType)) {
                try {
                    entity = new StringEntity(body);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ApiException("\u8bbe\u7f6ebody\u5931\u8d25", 5000, e);
                }
            } else {
                entity = new StringEntity(body, ContentType.create((String)contentType, (Charset)Config.UTF_8));
            }
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        return this.doRequest(request, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(HttpUriRequest request, int tryTimes) {
        int code;
        CloseableHttpResponse response;
        block18: {
            response = null;
            code = 5000;
            response = this.httpclient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            code = statusLine.getStatusCode();
            if (code != 200 && code != 400 && code != 401 && code != 403) break block18;
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
        }
        try {
            try {
                if (code == 404) {
                    throw new ApiException("not found.", code);
                }
                if (code == 504) {
                    throw new ApiException("timeout.", code);
                }
                throw new ApiException("Http Response Error.", code);
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                if (tryTimes > this.maxHttpTryTime) {
                    throw new ApiException("http error", code, e);
                }
                String string = this.doRequest(request, ++tryTimes);
                return string;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private HttpUriRequest genHttpUriRequest(String url, String method) {
        Object request = null;
        if (CommonEnum.MethodEnum.METHOD_GET.is(method)) {
            request = new HttpGet(url);
        } else if (CommonEnum.MethodEnum.METHOD_POST.is(method)) {
            request = new HttpPost(url);
        } else if (CommonEnum.MethodEnum.METHOD_DELETE.is(method)) {
            request = new GtHttpDelete(url);
        } else if (CommonEnum.MethodEnum.METHOD_PUT.is(method)) {
            request = new HttpPut(url);
        } else if (CommonEnum.MethodEnum.METHOD_HEAD.is(method)) {
            request = new HttpHead(url);
        } else if (CommonEnum.MethodEnum.METHOD_PATCH.is(method)) {
            request = new HttpPatch(url);
        } else if (CommonEnum.MethodEnum.METHOD_OPTIONS.is(method)) {
            request = new HttpOptions(url);
        } else if (CommonEnum.MethodEnum.METHOD_TRACE.is(method)) {
            request = new HttpTrace(url);
        } else {
            throw new ApiException("\u6682\u65f6\u4e0d\u652f\u6301" + method + "\u65b9\u6cd5");
        }
        return request;
    }
}

