/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk;

import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.IJson;
import com.getui.push.v2.sdk.api.AuthApi;
import com.getui.push.v2.sdk.common.Assert;
import com.getui.push.v2.sdk.core.DefaultJson;
import com.getui.push.v2.sdk.core.client.DefaultApiClient;
import com.getui.push.v2.sdk.core.factory.GtApiProxyFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ApiHelper {
    private final GtApiProxyFactory gtApiProxyFactory;
    private static final Object BUILD_LOCK = new Object();
    private static final Map<String, ApiHelper> apiHelperCache = new ConcurrentHashMap<String, ApiHelper>(4);

    public static ApiHelper build(GtApiConfiguration configuration) {
        return ApiHelper.build(configuration, new DefaultJson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiHelper build(GtApiConfiguration configuration, IJson json) {
        Assert.notNull(configuration, "configuration");
        configuration.check();
        String key = configuration.keyOfCache();
        ApiHelper apiHelper = apiHelperCache.get(key);
        if (apiHelper != null) {
            return apiHelper;
        }
        if (json == null) {
            json = new DefaultJson();
        }
        Object object = BUILD_LOCK;
        synchronized (object) {
            apiHelper = apiHelperCache.get(key);
            if (apiHelper != null) {
                return apiHelper;
            }
            DefaultApiClient defaultApiClient = DefaultApiClient.build(configuration, json);
            GtApiProxyFactory factory = GtApiProxyFactory.build(defaultApiClient);
            AuthApi authApi = factory.createProxy(AuthApi.class);
            defaultApiClient.setAuthApiAndAuth(authApi);
            apiHelper = new ApiHelper(factory);
            apiHelperCache.put(key, apiHelper);
            return apiHelper;
        }
    }

    public static void close(GtApiConfiguration configuration) {
        Assert.notNull(configuration, "configuration");
        configuration.check();
        String key = configuration.keyOfCache();
        ApiHelper apiHelper = apiHelperCache.remove(key);
        if (apiHelper != null) {
            apiHelper.gtApiProxyFactory.close();
        }
    }

    private ApiHelper(GtApiProxyFactory gtApiProxyFactory) {
        this.gtApiProxyFactory = gtApiProxyFactory;
    }

    public <T> T creatApi(Class<T> apiClass) {
        return this.gtApiProxyFactory.createProxy(apiClass);
    }
}

