/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.client;

import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.IJson;
import com.getui.push.v2.sdk.api.AuthApi;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.common.Assert;
import com.getui.push.v2.sdk.common.http.HttpManager;
import com.getui.push.v2.sdk.common.type.TypeReference;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.core.domain.RasDomainBO;
import com.getui.push.v2.sdk.core.factory.GtApiProxyFactory;
import com.getui.push.v2.sdk.core.handler.GtInterceptor;
import com.getui.push.v2.sdk.core.handler.impl.DefaultGtInterceptor;
import com.getui.push.v2.sdk.core.manager.HostManager;
import com.getui.push.v2.sdk.core.status.ServiceState;
import com.getui.push.v2.sdk.core.status.StateWrapper;
import com.getui.push.v2.sdk.dto.req.AuthDTO;
import com.getui.push.v2.sdk.dto.res.TokenDTO;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiClient {
    private static Logger log = LoggerFactory.getLogger(DefaultApiClient.class);
    private static ConcurrentMap<String, DefaultApiClient> cache = new ConcurrentHashMap<String, DefaultApiClient>(2);
    private static final Object CACHE_LOCK = new Object();
    private GtApiConfiguration apiConfiguration;
    private TokenDTO token;
    final String CONTENT_TYPE = "application/json";
    private final List<GtInterceptor> interceptorList = new ArrayList<GtInterceptor>();
    private HostManager hostManager;
    private IJson json;
    private boolean closed = false;
    private DefaultGtInterceptor defaultGtInterceptor;
    private HttpManager httpManager;
    private final BlockingQueue<Object> analyseDomainQueue = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<StateWrapper> reportDataQueue = new ArrayBlockingQueue<StateWrapper>(10);
    private AuthApi authApi;
    static final Pattern HIDE_MASTER_SECRET_PATTERN = Pattern.compile("(.{3}).+(.{3})");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultApiClient build(GtApiConfiguration apiConfiguration, IJson json) {
        apiConfiguration.check();
        if (json == null) {
            throw new InvalidParameterException("IJson \u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        String key = apiConfiguration.keyOfCache();
        DefaultApiClient defaultApiClient = (DefaultApiClient)cache.get(key);
        if (defaultApiClient == null) {
            String prefixOfKey = apiConfiguration.prefixOfKey();
            Object object = CACHE_LOCK;
            synchronized (object) {
                Iterator iterator = cache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!((String)entry.getKey()).startsWith(prefixOfKey)) continue;
                    DefaultApiClient.checkAppInfo(apiConfiguration, json);
                    defaultApiClient = (DefaultApiClient)entry.getValue();
                    defaultApiClient.apiConfiguration = apiConfiguration;
                    iterator.remove();
                }
                if (defaultApiClient == null) {
                    defaultApiClient = new DefaultApiClient(apiConfiguration, json);
                }
                cache.put(key, defaultApiClient);
            }
        }
        return defaultApiClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAppInfo(GtApiConfiguration configuration, IJson json) {
        DefaultApiClient client = null;
        try {
            GtApiConfiguration apiConfiguration = new GtApiConfiguration();
            apiConfiguration.setAppId(configuration.getAppId());
            apiConfiguration.setAppKey(configuration.getAppKey());
            apiConfiguration.setMasterSecret(configuration.getMasterSecret());
            apiConfiguration.setDomain(configuration.getDomain());
            apiConfiguration.setOpenCheckHealthDataSwitch(false);
            apiConfiguration.setOpenAnalyseStableDomainSwitch(false);
            apiConfiguration.setTrustSSL(configuration.isTrustSSL());
            apiConfiguration.setProxyConfig(configuration.getProxyConfig());
            client = new DefaultApiClient(apiConfiguration, json);
            String fullUrl = client.genFullUrl("/auth", null, null);
            AuthDTO authDTO = AuthDTO.build(apiConfiguration.getAppKey(), apiConfiguration.getMasterSecret());
            String result = client.httpManager.syncHttps(fullUrl, "POST", null, json.toJson(authDTO), client.CONTENT_TYPE);
            ApiResult apiResult = (ApiResult)json.fromJson(result, new TypeReference<ApiResult<TokenDTO>>(){}.getType());
            if (!apiResult.isSuccess()) {
                String hideSecret = HIDE_MASTER_SECRET_PATTERN.matcher(apiConfiguration.getMasterSecret()).replaceAll("$1********************$2");
                log.error("check app info failed. appId: {}, appKey: {}, masterSecret: {}, result: {}", new Object[]{apiConfiguration.getAppId(), apiConfiguration.getAppKey(), hideSecret, apiResult});
                throw new RuntimeException("check app info failed. please check app info. appId: " + apiConfiguration.getAppId() + ", appKey: " + apiConfiguration.getAppKey() + ", masterSecret: " + hideSecret);
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    private DefaultApiClient(GtApiConfiguration apiConfiguration, IJson json) {
        if (apiConfiguration == null) {
            throw new ApiException("apiConfiguration cannot be null.", true);
        }
        this.json = json;
        apiConfiguration.check();
        this.apiConfiguration = apiConfiguration;
        this.httpManager = new HttpManager(apiConfiguration.getConnectTimeout(), apiConfiguration.getSoTimeout(), apiConfiguration.getConnectionRequestTimeout(), apiConfiguration.getMaxHttpTryTime(), apiConfiguration.getKeepAliveSeconds(), apiConfiguration.getProxyConfig(), apiConfiguration.isTrustSSL());
        this.hostManager = new HostManager(apiConfiguration, this.httpManager);
        this.initAnalyseDomainThread();
        this.initReportDataThread();
        if (apiConfiguration.isOpenCheckHealthDataSwitch() || apiConfiguration.isOpenAnalyseStableDomainSwitch()) {
            this.defaultGtInterceptor = new DefaultGtInterceptor(this.hostManager, this.reportDataQueue, apiConfiguration);
            this.interceptorList.add(this.defaultGtInterceptor);
        }
    }

    private void initAnalyseDomainThread() {
        if (!this.apiConfiguration.isOpenAnalyseStableDomainSwitch()) {
            log.debug("The switch of analysing domain is closed.");
            return;
        }
        Thread analyseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!DefaultApiClient.this.closed) {
                    try {
                        DefaultApiClient.this.analyseDomainQueue.poll(DefaultApiClient.this.apiConfiguration.getAnalyseStableDomainInterval(), TimeUnit.MILLISECONDS);
                        log.debug("start to analyse domain.");
                        DefaultApiClient.this.hostManager.analyseStableDomain();
                    }
                    catch (Exception e) {
                        log.debug("analyse domain failed.", (Throwable)e);
                    }
                }
            }
        }, "analyse high domain thread");
        analyseThread.setDaemon(true);
        analyseThread.setPriority(5);
        analyseThread.start();
    }

    private void initReportDataThread() {
        if (!this.apiConfiguration.isOpenCheckHealthDataSwitch()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!DefaultApiClient.this.closed) {
                    try {
                        StateWrapper stateWrapper = (StateWrapper)DefaultApiClient.this.reportDataQueue.poll(DefaultApiClient.this.apiConfiguration.getCheckHealthInterval(), TimeUnit.MILLISECONDS);
                        if (!DefaultApiClient.this.apiConfiguration.isOpenCheckHealthDataSwitch()) continue;
                        log.debug("start to report data.");
                        if (stateWrapper == null) {
                            stateWrapper = DefaultApiClient.this.defaultGtInterceptor.getAndRemove(DefaultApiClient.this.hostManager.getUsing());
                        }
                        if (stateWrapper == null) {
                            return;
                        }
                        DefaultApiClient.this.uploadHealthyData(stateWrapper);
                    }
                    catch (Exception exception) {}
                }
            }
        }, "reportDataThread");
        thread.setDaemon(true);
        thread.setPriority(5);
        thread.start();
    }

    private void uploadHealthyData(StateWrapper stateWrapper) {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("token", this.token.getToken());
        try {
            String fullUrl = this.genFullUrl("/log/upload", null, null);
            String result = this.httpManager.syncHttps(fullUrl, "POST", header, this.buildSdkHealthData(stateWrapper), this.CONTENT_TYPE);
            log.debug("upload data. result: {}", (Object)result);
        }
        catch (Exception e) {
            log.debug("upload data failed.", (Throwable)e);
        }
    }

    private String buildSdkHealthData(StateWrapper stateWrapper) {
        ConcurrentMap<String, ServiceState> stateData = stateWrapper.getUriToServiceState();
        if (stateData == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis());
        map.put("pushData", stateData);
        map.put("host", stateWrapper.getHost());
        map.put("highSwitch", this.apiConfiguration.isOpenAnalyseStableDomainSwitch());
        map.put("sdkVersion", "1.0.0.11");
        map.put("switchIncr", this.hostManager.getSwitchIncrNum());
        map.put("switchTotal", this.hostManager.getSwitchTotalNum());
        return this.json.toJson(map);
    }

    protected void beforeExecute(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body) {
        if (Utils.isEmpty(this.interceptorList)) {
            return;
        }
        for (GtInterceptor gtInterceptor : this.interceptorList) {
            gtInterceptor.pre(apiParam, header, body);
        }
    }

    public ApiResult<?> execute(GtApiProxyFactory.ApiParam apiParam) {
        Assert.notNull(this.authApi, "authApi");
        TokenDTO token = this.token;
        ApiResult<?> apiResult = this.doExecute(apiParam, token);
        if (apiResult.getCode() == 10001) {
            this.refreshTokenAndGet(token);
            return this.doExecute(apiParam, this.token);
        }
        if (apiResult.getCode() == 301) {
            log.debug("domain changed. result: {}", apiResult);
            this.hostManager.handleDomain(this.json.fromJson(this.json.toJson(apiResult.getData()), RasDomainBO.class));
            this.analyseDomainQueue.offer("");
            return this.doExecute(apiParam, token);
        }
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult<?> doExecute(GtApiProxyFactory.ApiParam apiParam, TokenDTO token) {
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        if (apiParam.getNeedToken().booleanValue()) {
            if (token == null) {
                header.put("token", this.refreshTokenAndGet(token));
            } else {
                header.put("token", token.getToken());
            }
        }
        String body = null;
        if (apiParam.getBody() != null) {
            body = this.json.toJson(apiParam.getBody());
        }
        String result = null;
        String fullUrl = this.genFullUrl(apiParam.getUri(), apiParam.getPathParams(), apiParam.getQueryParams());
        try {
            this.handleHeader(header);
            this.beforeExecute(apiParam, header, body);
            result = this.httpManager.syncHttps(fullUrl, apiParam.getMethod(), header, body, "application/json");
            this.postExecute(apiParam, header, body, result);
        }
        catch (ApiException e) {
            try {
                this.handleException(apiParam, header, body, e);
                ApiResult apiResult = ApiResult.fail(e.getMessage(), e.getCode());
                this.afterDoExecute(apiParam, header, body, result);
                return apiResult;
            }
            catch (Throwable throwable) {
                this.afterDoExecute(apiParam, header, body, result);
                throw throwable;
            }
        }
        this.afterDoExecute(apiParam, header, body, result);
        if (result == null) {
            throw new ApiException(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002url:%s, body: %s.", fullUrl, body));
        }
        try {
            ApiResult apiResult = (ApiResult)this.json.fromJson(result, apiParam.getReturnType());
            if (apiResult.getCode() == 301) {
                apiResult = this.json.fromJson(result, ApiResult.class);
            }
            if (apiResult == null) {
                throw new ApiException(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c\u89e3\u6790\u8fd4\u56de\u503c\u5931\u8d25\u3002url:%s, body: %s, result: %s.", fullUrl, body, result));
            }
            return apiResult;
        }
        catch (Exception e) {
            ApiResult apiResult = this.json.fromJson(result, ApiResult.class);
            if (apiResult == null) {
                throw new ApiException(String.format("\u8bf7\u6c42\u5931\u8d25\uff0c\u89e3\u6790\u8fd4\u56de\u503c\u5931\u8d25\u3002url:%s, body: %s, result: %s.", fullUrl, body, result));
            }
            return apiResult;
        }
    }

    private void handleHeader(Map<String, Object> header) {
        header.put("sdkVersion", "1.0.0.11");
        if (!this.apiConfiguration.isOpenAnalyseStableDomainSwitch()) {
            return;
        }
        header.put("openStableDomain", Boolean.TRUE);
        if (Utils.isNotEmpty(this.hostManager.domainHash())) {
            header.put("domainHash", this.hostManager.domainHash());
        }
    }

    protected void postExecute(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, String result) {
        if (Utils.isEmpty(this.interceptorList)) {
            return;
        }
        for (GtInterceptor gtInterceptor : this.interceptorList) {
            gtInterceptor.post(apiParam, header, body, result);
        }
    }

    protected void handleException(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, ApiException e) {
        if (Utils.isEmpty(this.interceptorList)) {
            return;
        }
        for (GtInterceptor gtInterceptor : this.interceptorList) {
            gtInterceptor.handleException(apiParam, header, body, e);
        }
    }

    protected void afterDoExecute(GtApiProxyFactory.ApiParam apiParam, Map<String, Object> header, String body, String result) {
        if (Utils.isEmpty(this.interceptorList)) {
            return;
        }
        for (GtInterceptor gtInterceptor : this.interceptorList) {
            gtInterceptor.afterCompletion(apiParam, header, body, result);
        }
    }

    private synchronized String refreshTokenAndGet(TokenDTO usedToken) {
        TokenDTO token = this.token;
        if (usedToken != token && token != null && usedToken != null && !token.expired()) {
            return token.getToken();
        }
        AuthDTO authDTO = AuthDTO.build(this.apiConfiguration.getAppKey(), this.apiConfiguration.getMasterSecret());
        ApiResult<TokenDTO> apiResult = this.authApi.auth(authDTO);
        if (!apiResult.isSuccess()) {
            log.error("get auth token failed. code: {}, msg: {}, param: {}.", new Object[]{apiResult.getCode(), apiResult.getMsg(), authDTO});
            throw new ApiException("\u83b7\u53d6token\u5931\u8d25: " + apiResult.getMsg(), true);
        }
        this.token = apiResult.getData();
        if (this.token == null) {
            throw new ApiException("\u83b7\u53d6token\u5931\u8d25: " + apiResult.getMsg(), true);
        }
        return this.token.getToken();
    }

    private String genFullUrl(String uri, String pathParams, List<String> queryParams) {
        String host = this.hostManager.getUsing();
        if (!host.endsWith("v2") && !host.endsWith("v2/")) {
            host = host.endsWith("/") ? host + "v2/" : host + "/v2/";
        }
        if (!host.contains(this.apiConfiguration.getAppId())) {
            host = host.endsWith("/") ? host + this.apiConfiguration.getAppId() : host + "/" + this.apiConfiguration.getAppId();
        }
        host = Utils.isEmpty(pathParams) ? host + uri : (Pattern.matches(".*\\$\\{.+}.*", host = host + uri) ? host.replaceAll("\\$\\{.+}", pathParams) : (host.endsWith("/") ? host + pathParams : host + "/" + pathParams));
        if (Utils.isEmpty(queryParams)) {
            return host;
        }
        StringBuilder queryParamSb = new StringBuilder();
        for (String param : queryParams) {
            queryParamSb.append(param).append("&");
        }
        String queryParam = queryParamSb.substring(0, queryParamSb.length() - 1);
        return host + "?" + queryParam;
    }

    public void setJson(IJson json) {
        this.json = json;
    }

    public void close() {
        this.closed = true;
    }

    public void setAuthApiAndAuth(AuthApi authApi) {
        if (authApi == null) {
            throw new ApiException("authApi \u4e0d\u80fd\u4e3anull");
        }
        this.authApi = authApi;
        try {
            this.refreshTokenAndGet(null);
        }
        catch (ApiException e) {
            log.error("refresh token failed.", (Throwable)e);
            throw e;
        }
    }
}

