/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk;

import com.getui.push.v2.sdk.GtHttpProxyConfig;
import com.getui.push.v2.sdk.common.Assert;

public class GtApiConfiguration {
    private String appId;
    private String appKey;
    private String masterSecret;
    private String domain = "https://restapi.getui.com/v2";
    private boolean openAnalyseStableDomainSwitch = true;
    private long analyseStableDomainInterval = 120000L;
    public static final String CHECK_HEALTH_DATA_SWITCH_KEY = "gt_healthy_switch";
    private long checkHealthInterval = 30000L;
    private int soTimeout = 30000;
    private int connectTimeout = 60000;
    private int maxHttpTryTime = 1;
    private long keepAliveSeconds = 10L;
    final long MAX_KEEP_ALIVE_SECONDS = 30L;
    private boolean trustSSL = false;
    private GtHttpProxyConfig proxyConfig;

    public void setDomain(String domain) {
        Assert.notBlank(domain, true);
        this.domain = domain;
    }

    public void check() {
        Assert.notBlank(this.appId, true);
        Assert.notBlank(this.appKey, true);
        Assert.notBlank(this.masterSecret, true);
        Assert.notBlank(this.domain, true);
    }

    public boolean isTrustSSL() {
        return this.trustSSL;
    }

    public void setTrustSSL(boolean trustSSL) {
        this.trustSSL = trustSSL;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isOpenAnalyseStableDomainSwitch() {
        return this.openAnalyseStableDomainSwitch;
    }

    public void setOpenAnalyseStableDomainSwitch(boolean openAnalyseStableDomainSwitch) {
        this.openAnalyseStableDomainSwitch = openAnalyseStableDomainSwitch;
    }

    public long getAnalyseStableDomainInterval() {
        return this.analyseStableDomainInterval;
    }

    public void setAnalyseStableDomainInterval(long analyseStableDomainInterval) {
        this.analyseStableDomainInterval = analyseStableDomainInterval;
    }

    public boolean isOpenCheckHealthDataSwitch() {
        return Boolean.getBoolean(CHECK_HEALTH_DATA_SWITCH_KEY);
    }

    public void setOpenCheckHealthDataSwitch(boolean openCheckHealthDataSwitch) {
        System.setProperty(CHECK_HEALTH_DATA_SWITCH_KEY, String.valueOf(openCheckHealthDataSwitch));
    }

    public long getCheckHealthInterval() {
        return this.checkHealthInterval;
    }

    public void setCheckHealthInterval(long checkHealthInterval) {
        this.checkHealthInterval = checkHealthInterval;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxHttpTryTime() {
        return this.maxHttpTryTime;
    }

    public void setMaxHttpTryTime(int maxHttpTryTime) {
        this.maxHttpTryTime = maxHttpTryTime;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setKeepAliveSeconds(long keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds > 30L ? 30L : keepAliveSeconds;
    }

    @Deprecated
    public long getKeepAliveMinutes() {
        return 0L;
    }

    @Deprecated
    public void setKeepAliveMinutes(long keepAliveMinutes) {
    }

    public GtHttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(GtHttpProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GtApiConfiguration that = (GtApiConfiguration)o;
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        if (!this.appKey.equals(that.appKey)) {
            return false;
        }
        return this.masterSecret.equals(that.masterSecret);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.appKey.hashCode();
        result = 31 * result + this.masterSecret.hashCode();
        return result;
    }

    public String keyOfCache() {
        this.check();
        return String.format("%s|%s|%s", this.getAppId(), this.getAppKey(), this.getMasterSecret());
    }

    public String prefixOfKey() {
        this.check();
        return String.format("%s|%s", this.getAppId(), this.getAppKey());
    }
}

