/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.common;

import com.getui.push.v2.sdk.common.util.Utils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    private static Logger log = LoggerFactory.getLogger(Monitor.class);
    static volatile Map<String, AtomicInteger> hostToFailedNumMap;
    static volatile boolean MONITOR_ENABLE;

    public static void init(long refreshTimes) {
        hostToFailedNumMap = new ConcurrentHashMap<String, AtomicInteger>(16);
        MONITOR_ENABLE = true;
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(refreshTimes);
                        log.debug("will reset monitor|{}", hostToFailedNumMap);
                        Iterator<Map.Entry<String, AtomicInteger>> iterator = hostToFailedNumMap.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            iterator.next().getValue().set(0);
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.setName("gtResetMonitor");
        thread.start();
    }

    public static int get(String host) {
        if (!MONITOR_ENABLE || host == null) {
            return 0;
        }
        AtomicInteger num = hostToFailedNumMap.computeIfAbsent(Utils.v2UrlToHost(host), k -> new AtomicInteger());
        return num.get();
    }

    public static void reset(String host) {
        if (!MONITOR_ENABLE || host == null) {
            return;
        }
        AtomicInteger num = hostToFailedNumMap.computeIfAbsent(Utils.v2UrlToHost(host), k -> new AtomicInteger());
        num.set(0);
    }

    public static void incrementFailedNum(String host) {
        if (!MONITOR_ENABLE || host == null) {
            return;
        }
        AtomicInteger num = hostToFailedNumMap.computeIfAbsent(Utils.v2UrlToHost(host), k -> new AtomicInteger());
        num.incrementAndGet();
    }

    static {
        MONITOR_ENABLE = false;
    }
}

