/*
 * Decompiled with CFR 0.152.
 */
package com.appleyk.verify.interceptor;

import com.appleyk.core.ex.CommonException;
import com.appleyk.core.model.LicenseExtraParam;
import com.appleyk.core.model.LicenseResult;
import com.appleyk.core.model.LicenseVerifyManager;
import com.appleyk.core.result.ResultCode;
import com.appleyk.core.utils.CommonUtils;
import com.appleyk.verify.annotion.VLicense;
import com.appleyk.verify.config.LicenseVerifyProperties;
import com.appleyk.verify.listener.ACustomVerifyListener;
import de.schlichtherle.license.LicenseContent;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LicenseVerifyInterceptor
implements HandlerInterceptor {
    @Autowired
    private LicenseVerifyProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Method method;
        VLicense annotation;
        if (handler instanceof HandlerMethod && CommonUtils.isNotEmpty((Object)(annotation = (method = (handlerMethod = (HandlerMethod)handler).getMethod()).getAnnotation(VLicense.class)))) {
            LicenseVerifyManager licenseVerifyManager = new LicenseVerifyManager();
            LicenseResult verifyResult = licenseVerifyManager.verify(this.properties.getVerifyParam());
            if (!verifyResult.getResult().booleanValue()) {
                throw new CommonException(verifyResult.getMessage());
            }
            LicenseContent content = verifyResult.getContent();
            LicenseExtraParam licenseCheck = (LicenseExtraParam)content.getExtra();
            if (verifyResult.getResult().booleanValue()) {
                List<ACustomVerifyListener> customListenerList = ACustomVerifyListener.getCustomListenerList();
                boolean compare = true;
                for (ACustomVerifyListener listener : customListenerList) {
                    boolean verify = listener.verify(licenseCheck);
                    compare = compare && verify;
                }
                return compare;
            }
            throw new CommonException(ResultCode.FAIL, verifyResult.getException().getMessage());
        }
        return true;
    }
}

