/*
 * Decompiled with CFR 0.152.
 */
package com.appleyk.verify.listener;

import com.appleyk.core.helper.LoggerHelper;
import com.appleyk.core.model.LicenseResult;
import com.appleyk.core.model.LicenseVerifyManager;
import com.appleyk.core.utils.CommonUtils;
import com.appleyk.verify.config.LicenseVerifyProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.ResourceUtils;

@Component
public class LicenseVerifyListener
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private LicenseVerifyProperties properties;
    private static String md5 = "";
    private static boolean isLoad = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (CommonUtils.isNotEmpty((Object)this.properties.getLicensePath())) {
            this.install();
            try {
                String readMd5 = this.getMd5(this.properties.getLicensePath());
                isLoad = true;
                if (md5 == null || "".equals(md5)) {
                    md5 = readMd5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Scheduled(cron="0/5 * * * * ?")
    protected void timer() throws Exception {
        if (!isLoad) {
            return;
        }
        String readMd5 = this.getMd5(this.properties.getLicensePath());
        if (!readMd5.equals(md5)) {
            this.install();
            md5 = readMd5;
        }
    }

    private void install() {
        LoggerHelper.info((String)"++++++++ \u5f00\u59cb\u5b89\u88c5\u8bc1\u4e66 ++++++++");
        LicenseVerifyManager licenseVerifyManager = new LicenseVerifyManager();
        LicenseResult result = licenseVerifyManager.install(this.properties.getVerifyParam());
        if (result.getResult().booleanValue()) {
            LoggerHelper.info((String)"++++++++ \u8bc1\u4e66\u5b89\u88c5\u6210\u529f ++++++++");
        } else {
            LoggerHelper.info((String)"++++++++ \u8bc1\u4e66\u5b89\u88c5\u5931\u8d25 ++++++++");
        }
    }

    public String getMd5(String filePath) throws Exception {
        String md5 = "";
        try {
            File file = ResourceUtils.getFile((String)filePath);
            if (file.exists()) {
                FileInputStream is = new FileInputStream(file);
                byte[] data = new byte[is.available()];
                is.read(data);
                md5 = DigestUtils.md5DigestAsHex((byte[])data);
                is.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return md5;
    }
}

