/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private Stack fieldNames = new Stack();
    private Stack fieldValues = new Stack();
    HashMap fields;
    protected HashMap listFields;
    String fileSpec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XfdfReader(String filename) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filename);
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fin);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public XfdfReader(byte[] xfdfIn) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, new ByteArrayInputStream(xfdfIn));
    }

    public HashMap getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return (String)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        String field = (String)this.fields.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    public List getListValues(String name) {
        return (List)this.listFields.get(name);
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    @Override
    public void startElement(String tag, HashMap h) {
        if (!this.foundRoot) {
            if (!tag.equals("xfdf")) {
                throw new RuntimeException("Root element is not Bookmark.");
            }
            this.foundRoot = true;
        }
        if (!tag.equals("xfdf")) {
            if (tag.equals("f")) {
                this.fileSpec = (String)h.get("href");
            } else if (tag.equals("fields")) {
                this.fields = new HashMap();
                this.listFields = new HashMap();
            } else if (tag.equals("field")) {
                String fName = (String)h.get("name");
                this.fieldNames.push(fName);
            } else if (tag.equals("value")) {
                this.fieldValues.push("");
            }
        }
    }

    @Override
    public void endElement(String tag) {
        if ("value".equals(tag)) {
            String fVal;
            String fNameString;
            String old;
            StringBuilder fName = new StringBuilder();
            for (int k = 0; k < this.fieldNames.size(); ++k) {
                fName.append(".").append((String)this.fieldNames.elementAt(k));
            }
            if (fName.charAt(0) == '.') {
                fName.deleteCharAt(0);
            }
            if ((old = this.fields.put(fNameString = fName.toString(), fVal = (String)this.fieldValues.pop())) != null) {
                ArrayList<String> l = (ArrayList<String>)this.listFields.get(fNameString);
                if (l == null) {
                    l = new ArrayList<String>();
                    l.add(old);
                }
                l.add(fVal);
                this.listFields.put(fNameString, l);
            }
        } else if ("field".equals(tag) && !this.fieldNames.isEmpty()) {
            this.fieldNames.pop();
        }
    }

    @Override
    public void startDocument() {
        this.fileSpec = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(String str) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        String val = (String)this.fieldValues.pop();
        val = val + str;
        this.fieldValues.push(val);
    }
}

