/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.ContentOperator;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public abstract class PdfContentStreamProcessor {
    private Map<String, ContentOperator> operators;
    private DictionaryStack resources;
    private Stack<GraphicsState> gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;

    public PdfContentStreamProcessor() {
        this.populateOperators();
        this.reset();
    }

    private void populateOperators() {
        this.operators = new HashMap<String, ContentOperator>();
        this.registerContentOperator("q", new PushGraphicsState());
        this.registerContentOperator("Q", new PopGraphicsState());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrix());
        this.registerContentOperator("gs", new ProcessGraphicsStateResource());
        this.registerContentOperator("Tc", new SetTextCharacterSpacing());
        this.registerContentOperator("Tw", new SetTextWordSpacing());
        this.registerContentOperator("Tz", new SetTextHorizontalScaling());
        this.registerContentOperator("TL", new SetTextLeading());
        this.registerContentOperator("Tf", new SetTextFont());
        this.registerContentOperator("Tr", new SetTextRenderMode());
        this.registerContentOperator("Ts", new SetTextRise());
        this.registerContentOperator("BT", new BeginText());
        this.registerContentOperator("ET", new EndText());
        this.registerContentOperator("Td", new TextMoveStartNextLine());
        this.registerContentOperator("TD", new TextMoveStartNextLineWithLeading());
        this.registerContentOperator("Tm", new TextSetTextMatrix());
        this.registerContentOperator("T*", new TextMoveNextLine());
        this.registerContentOperator("Tj", new ShowText());
        this.registerContentOperator("'", new MoveNextLineAndShowText());
        this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacing());
        this.registerContentOperator("TJ", new ShowTextArray());
        this.registerContentOperator("Do", new Do());
    }

    public void registerContentOperator(String operatorString, ContentOperator operator) {
        if (this.operators.containsKey(operatorString)) {
            throw new IllegalArgumentException("Operator " + operatorString + " already registered");
        }
        this.operators.put(operatorString, operator);
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = new DictionaryStack();
    }

    public GraphicsState gs() {
        return this.gsStack.peek();
    }

    public Matrix getCurrentTextMatrix() {
        return this.textMatrix;
    }

    public Matrix getCurrentTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void invokeOperator(PdfLiteral operator, ArrayList operands) {
        ContentOperator op = this.operators.get(operator.toString());
        if (op == null) {
            return;
        }
        op.invoke(this, operator, operands);
    }

    private String decode(PdfString in) {
        byte[] bytes = in.getBytes();
        return this.gs().font.decode(bytes, 0, bytes.length);
    }

    public abstract void displayText(String var1, Matrix var2);

    public float getStringWidth(String string, float tj) {
        CMapAwareDocumentFont font = this.gs().font;
        char[] chars = string.toCharArray();
        float totalWidth = 0.0f;
        for (int i = 0; i < chars.length; ++i) {
            float w = (float)((DocumentFont)font).getWidth(chars[i]) / 1000.0f;
            float wordSpacing = chars[i] == ' ' ? this.gs().wordSpacing : 0.0f;
            totalWidth += ((w - tj / 1000.0f) * this.gs().fontSize + this.gs().characterSpacing + wordSpacing) * this.gs().horizontalScaling;
        }
        return totalWidth;
    }

    public void displayPdfString(PdfString string, float tj) {
        String unicode = this.decode(string);
        float width = this.getStringWidth(unicode, tj);
        Matrix nextTextMatrix = new Matrix(width, 0.0f).multiply(this.textMatrix);
        this.displayText(unicode, nextTextMatrix);
        this.textMatrix = nextTextMatrix;
    }

    public void processContent(byte[] contentBytes, PdfDictionary resources) {
        this.resources.push(resources);
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(contentBytes));
            ArrayList operands = new ArrayList();
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
                this.invokeOperator(operator, operands);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.resources.pop();
    }

    private static class Do
    implements ContentOperator {
        private Do() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfName name = (PdfName)operands.get(0);
            PdfDictionary xobject = processor.resources.getAsDict(PdfName.XOBJECT);
            if (xobject == null) {
                return;
            }
            PdfStream stream = (PdfStream)xobject.getDirectObject(name);
            PdfName subType = stream.getAsName(PdfName.SUBTYPE);
            if (PdfName.FORM.equals(subType)) {
                byte[] data;
                PdfDictionary resources = stream.getAsDict(PdfName.RESOURCES);
                try {
                    data = Do.getContentBytesFromPdfObject(stream);
                }
                catch (IOException ex) {
                    throw new ExceptionConverter(ex);
                }
                new PushGraphicsState().invoke(processor, null, null);
                PdfArray matrix = stream.getAsArray(PdfName.MATRIX);
                if (matrix != null) {
                    Matrix formMatrix = new Matrix(matrix.getAsNumber(0).floatValue(), matrix.getAsNumber(1).floatValue(), matrix.getAsNumber(2).floatValue(), matrix.getAsNumber(3).floatValue(), matrix.getAsNumber(4).floatValue(), matrix.getAsNumber(5).floatValue());
                    processor.gs().ctm = formMatrix.multiply(processor.gs().ctm);
                }
                processor.processContent(data, resources);
                new PopGraphicsState().invoke(processor, null, null);
            }
        }

        public static byte[] getContentBytesFromPdfObject(PdfObject object) throws IOException {
            switch (object.type()) {
                case 10: {
                    return Do.getContentBytesFromPdfObject(PdfReader.getPdfObject(object));
                }
                case 7: {
                    return PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObject(object));
                }
                case 5: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ListIterator iter = ((PdfArray)object).listIterator();
                    while (iter.hasNext()) {
                        PdfObject element = (PdfObject)iter.next();
                        baos.write(Do.getContentBytesFromPdfObject(element));
                    }
                    return baos.toByteArray();
                }
            }
            throw new IllegalStateException("Unsupported type: " + object.getClass().getCanonicalName());
        }
    }

    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.textMatrix = null;
            processor.textLineMatrix = null;
        }
    }

    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.textMatrix = new Matrix();
            processor.textLineMatrix = processor.textMatrix;
        }
    }

    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.gsStack.pop();
        }
    }

    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            Matrix matrix = new Matrix(a, b, c, d, e, f);
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            gs.ctm = gs.ctm.multiply(matrix);
        }
    }

    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            GraphicsState copy = new GraphicsState(gs);
            processor.gsStack.push(copy);
        }
    }

    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfName dictionaryName = (PdfName)operands.get(0);
            PdfDictionary extGState = processor.resources.getAsDict(PdfName.EXTGSTATE);
            if (extGState == null) {
                throw new IllegalArgumentException("Resources do not contain ExtGState entry. Unable to process operator " + operator);
            }
            PdfDictionary gsDic = extGState.getAsDict(dictionaryName);
            if (gsDic == null) {
                throw new IllegalArgumentException(dictionaryName + " is an unknown graphics state dictionary");
            }
            PdfArray fontParameter = gsDic.getAsArray(PdfName.FONT);
            if (fontParameter != null) {
                CMapAwareDocumentFont font = new CMapAwareDocumentFont((PRIndirectReference)fontParameter.getPdfObject(0));
                float size = fontParameter.getAsNumber(1).floatValue();
                processor.gs().font = font;
                processor.gs().fontSize = size;
            }
        }
    }

    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber wordSpace = (PdfNumber)operands.get(0);
            processor.gs().wordSpacing = wordSpace.floatValue();
        }
    }

    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber charSpace = (PdfNumber)operands.get(0);
            processor.gs().characterSpacing = charSpace.floatValue();
        }
    }

    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber scale = (PdfNumber)operands.get(0);
            processor.gs().horizontalScaling = scale.floatValue();
        }
    }

    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber leading = (PdfNumber)operands.get(0);
            processor.gs().leading = leading.floatValue();
        }
    }

    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber rise = (PdfNumber)operands.get(0);
            processor.gs().rise = rise.floatValue();
        }
    }

    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber render = (PdfNumber)operands.get(0);
            processor.gs().renderMode = render.intValue();
        }
    }

    private static class SetTextFont
    implements ContentOperator {
        private SetTextFont() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            CMapAwareDocumentFont font;
            PdfName fontResourceName = (PdfName)operands.get(0);
            float size = ((PdfNumber)operands.get(1)).floatValue();
            PdfDictionary fontsDictionary = processor.resources.getAsDict(PdfName.FONT);
            processor.gs().font = font = new CMapAwareDocumentFont((PRIndirectReference)fontsDictionary.get(fontResourceName));
            processor.gs().fontSize = size;
        }
    }

    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float tx = ((PdfNumber)operands.get(0)).floatValue();
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            Matrix translationMatrix = new Matrix(tx, ty);
            processor.textMatrix = translationMatrix.multiply(processor.textLineMatrix);
            processor.textLineMatrix = processor.textMatrix;
        }
    }

    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private TextMoveStartNextLineWithLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            ArrayList<PdfNumber> tlOperands = new ArrayList<PdfNumber>(1);
            tlOperands.add(0, new PdfNumber(-ty));
            processor.invokeOperator(new PdfLiteral("TL"), tlOperands);
            processor.invokeOperator(new PdfLiteral("Td"), operands);
        }
    }

    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            processor.textLineMatrix = new Matrix(a, b, c, d, e, f);
            processor.textMatrix = processor.textLineMatrix;
        }
    }

    private static class TextMoveNextLine
    implements ContentOperator {
        private TextMoveNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            ArrayList<PdfNumber> tdoperands = new ArrayList<PdfNumber>(2);
            tdoperands.add(0, new PdfNumber(0));
            tdoperands.add(1, new PdfNumber(-processor.gs().leading));
            processor.invokeOperator(new PdfLiteral("Td"), tdoperands);
        }
    }

    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfString string = (PdfString)operands.get(0);
            processor.displayPdfString(string, 0.0f);
        }
    }

    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private MoveNextLineAndShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.invokeOperator(new PdfLiteral("T*"), new ArrayList(0));
            processor.invokeOperator(new PdfLiteral("Tj"), operands);
        }
    }

    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private MoveNextLineAndShowTextWithSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber aw = (PdfNumber)operands.get(0);
            PdfNumber ac = (PdfNumber)operands.get(1);
            PdfString string = (PdfString)operands.get(2);
            ArrayList<PdfNumber> twOperands = new ArrayList<PdfNumber>(1);
            twOperands.add(0, aw);
            processor.invokeOperator(new PdfLiteral("Tw"), twOperands);
            ArrayList<PdfNumber> tcOperands = new ArrayList<PdfNumber>(1);
            tcOperands.add(0, ac);
            processor.invokeOperator(new PdfLiteral("Tc"), tcOperands);
            ArrayList<PdfString> tickOperands = new ArrayList<PdfString>(1);
            tickOperands.add(0, string);
            processor.invokeOperator(new PdfLiteral("'"), tickOperands);
        }
    }

    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfArray array = (PdfArray)operands.get(0);
            float tj = 0.0f;
            ListIterator i = array.listIterator();
            while (i.hasNext()) {
                Object entryObj = i.next();
                if (entryObj instanceof PdfString) {
                    processor.displayPdfString((PdfString)entryObj, tj);
                    tj = 0.0f;
                    continue;
                }
                tj = ((PdfNumber)entryObj).floatValue();
            }
        }
    }

    private static class DictionaryStack
    extends PdfDictionary {
        private Stack<PdfDictionary> stack = new Stack();

        public void push(PdfDictionary resources) {
            this.stack.push(resources);
        }

        public void pop() {
            this.stack.pop();
        }

        @Override
        public PdfObject getDirectObject(PdfName key) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                PdfDictionary dict = (PdfDictionary)this.stack.get(i);
                PdfObject o = dict.getDirectObject(key);
                if (o == null) continue;
                return o;
            }
            return null;
        }
    }
}

