/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.rtf.parser.RtfImportMgr;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;

public final class RtfDestinationFontTable
extends RtfDestination {
    private RtfImportMgr importHeader = null;
    private String themeFont = "";
    private String fontNr = "";
    private String fontFamily = "";
    private String charset = "";
    private static final String CHARSET_DEFAULT = "0";
    private int fprq = 0;
    private String panose = "";
    private String nontaggedname = "";
    private String fontName = "";
    private String falt = "";
    private String fontemb = "";
    private String fontType = "";
    private String fontFile = "";
    private String fontFileCpg = "";
    private int fbias = 0;
    private String cpg = "";
    private String trueType = "";
    private int state = 0;
    private static final int SETTING_NORMAL = 0;
    private static final int SETTING_ALTERNATE = 1;
    private static final int SETTING_FONTNAME = 2;
    private static final int SETTING_PANOSE = 3;
    private static final int SETTING_FONT_EMBED = 4;
    private static final int SETTING_FONT_FILE = 5;
    private HashMap fontMap = null;

    public RtfDestinationFontTable() {
        super(null);
    }

    public RtfDestinationFontTable(RtfParser parser) {
        super(parser);
        this.init(true);
    }

    @Override
    public void setParser(RtfParser parser) {
        if (this.rtfParser != null && this.rtfParser.equals(parser)) {
            return;
        }
        this.rtfParser = parser;
        this.init(true);
    }

    private void init(boolean importFonts) {
        this.fontMap = new HashMap();
        if (this.rtfParser != null) {
            this.importHeader = this.rtfParser.getImportManager();
        }
        this.setToDefaults();
        if (importFonts) {
            this.importSystemFonts();
        }
    }

    @Override
    public boolean handleOpeningSubGroup() {
        return true;
    }

    @Override
    public boolean closeDestination() {
        return true;
    }

    @Override
    public boolean handleCloseGroup() {
        if (this.state == 0) {
            this.processFont();
        }
        this.state = 0;
        return true;
    }

    @Override
    public boolean handleOpenGroup() {
        return true;
    }

    @Override
    public boolean handleCharacter(int ch) {
        switch (this.state) {
            case 0: {
                this.fontName = this.fontName + (char)ch;
                break;
            }
            case 1: {
                this.falt = this.falt + (char)ch;
                break;
            }
            case 3: {
                this.panose = this.panose + (char)ch;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        return true;
    }

    @Override
    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        boolean result = true;
        if (ctrlWordData.ctrlWord.equals("f")) {
            this.setFontNumber(ctrlWordData.param);
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fcharset")) {
            this.setCharset(ctrlWordData.param);
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fnil")) {
            this.setFontFamily("roman");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("froman")) {
            this.setFontFamily("roman");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fswiss")) {
            this.setFontFamily("swiss");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fmodern")) {
            this.setFontFamily("modern");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fscript")) {
            this.setFontFamily("script");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fdecor")) {
            this.setFontFamily("decor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("ftech")) {
            this.setFontFamily("tech");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fbidi")) {
            this.setFontFamily("bidi");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fprq")) {
            this.setPitch(ctrlWordData.param);
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fbias")) {
            this.setBias(ctrlWordData.param);
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("flomajor")) {
            this.setThemeFont("flomajor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fhimajor")) {
            this.setThemeFont("fhimajor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fdbmajor")) {
            this.setThemeFont("fdbmajor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fbimajor")) {
            this.setThemeFont("fbimajor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("flominor")) {
            this.setThemeFont("flominor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fhiminor")) {
            this.setThemeFont("fhiminor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fdbminor")) {
            this.setThemeFont("fdbminor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fbiminor")) {
            this.setThemeFont("fbiminor");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("panose")) {
            this.state = 3;
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fname")) {
            this.state = 2;
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("falt")) {
            this.state = 1;
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fontemb")) {
            this.state = 4;
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("ftnil")) {
            this.setTrueType("ftnil");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fttruetype")) {
            this.setTrueType("fttruetype");
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("fontemb")) {
            this.state = 5;
            result = true;
        }
        if (ctrlWordData.ctrlWord.equals("cpg")) {
            this.setCodePage(ctrlWordData.param);
            result = true;
        }
        this.lastCtrlWord = ctrlWordData;
        return result;
    }

    public void setCodePage(String value) {
        this.cpg = value;
    }

    public void setTrueType(String value) {
        this.trueType = value;
    }

    public void setPitch(String value) {
        this.fprq = Integer.parseInt(value);
    }

    public void setBias(String value) {
        this.fbias = Integer.parseInt(value);
    }

    public void setThemeFont(String themeFont) {
        this.themeFont = themeFont;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void setFontNumber(String fontNr) {
        this.fontNr = fontNr;
    }

    public void setFontAlternate(String fontAlternate) {
        this.falt = fontAlternate;
    }

    public void setCharset(String charset) {
        if (charset.length() == 0) {
            charset = CHARSET_DEFAULT;
        }
        this.charset = charset;
    }

    @Override
    public void setToDefaults() {
        this.themeFont = "";
        this.fontNr = "";
        this.fontName = "";
        this.fontFamily = "";
        this.charset = "";
        this.fprq = 0;
        this.panose = "";
        this.nontaggedname = "";
        this.falt = "";
        this.fontemb = "";
        this.fontType = "";
        this.fontFile = "";
        this.fontFileCpg = "";
        this.fbias = 0;
        this.cpg = "";
        this.trueType = "";
        this.state = 0;
    }

    private void processFont() {
        this.fontName = this.fontName.trim();
        if (this.fontName.length() == 0) {
            return;
        }
        if (this.fontNr.length() == 0) {
            return;
        }
        if (this.fontName.length() > 0 && this.fontName.indexOf(59) >= 0) {
            this.fontName = this.fontName.substring(0, this.fontName.indexOf(59));
        }
        if (this.rtfParser.isImport() && !this.importHeader.importFont(this.fontNr, this.fontName, Integer.parseInt("".equals(this.charset) ? CHARSET_DEFAULT : this.charset)) && this.falt.length() > 0) {
            this.importHeader.importFont(this.fontNr, this.falt, Integer.parseInt("".equals(this.charset) ? CHARSET_DEFAULT : this.charset));
        }
        if (this.rtfParser.isConvert()) {
            String fName = this.fontName;
            Font f1 = this.createfont(fName);
            if (f1.getBaseFont() == null && this.falt.length() > 0) {
                f1 = this.createfont(this.falt);
            }
            if (f1.getBaseFont() == null) {
                f1 = "Courier".indexOf(fName) > -1 ? FontFactory.getFont("Courier") : ("Helvetica".indexOf(fName) > -1 ? FontFactory.getFont("Helvetica") : ("Times".indexOf(fName) > -1 ? FontFactory.getFont("Times") : ("Symbol".indexOf(fName) > -1 ? FontFactory.getFont("Symbol") : ("ZapfDingbats".indexOf(fName) > -1 ? FontFactory.getFont("ZapfDingbats") : FontFactory.getFont("Helvetica")))));
            }
            this.fontMap.put(this.fontNr, f1);
        }
        this.setToDefaults();
    }

    private Font createfont(String fontName) {
        Font f1 = null;
        int pos = -1;
        while ((f1 = FontFactory.getFont(fontName)).getBaseFont() == null) {
            pos = fontName.lastIndexOf(32);
            if (pos > 0) {
                fontName = fontName.substring(0, pos);
            }
            if (pos > 0) continue;
        }
        return f1;
    }

    public Font getFont(String key) {
        return (Font)this.fontMap.get(key);
    }

    private void importSystemFonts() {
        try {
            Properties pr = this.getEnvironmentVariables();
            String systemRoot = pr.getProperty("SystemRoot");
            String fileSeperator = System.getProperty("file.separator");
            FontFactory.registerDirectory(systemRoot + fileSeperator + "fonts");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Properties getEnvironmentVariables() throws Throwable {
        Properties environmentVariables = new Properties();
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        process = operatingSystem.startsWith("windows 95") || operatingSystem.startsWith("windows 98") || operatingSystem.startsWith("me") ? runtime.exec("command.com /c set") : (operatingSystem.startsWith("windows") ? runtime.exec("cmd.exe /c set") : runtime.exec("env"));
        BufferedReader environmentStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String inputLine = "";
        int idx = -1;
        while ((inputLine = environmentStream.readLine()) != null) {
            idx = inputLine.indexOf(61);
            environmentVariables.setProperty(inputLine.substring(0, idx), inputLine.substring(idx + 1));
        }
        return environmentVariables;
    }
}

