/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

public enum DBFDataType {
    UNKNOWN(0),
    CHARACTER('C', 1, 254, 0, true),
    VARCHAR('V', 1, 254, 0, false),
    VARBINARY('Q', 1, 254, 0, false),
    DATE('D', 8, 8, 8, true),
    FLOATING_POINT('F', 1, 20, 0, true),
    DOUBLE('O', 8, 8, 0, false),
    LOGICAL('L', 1, 1, 1, true),
    MEMO('M'),
    BINARY('B'),
    BLOB('W'),
    GENERAL_OLE('G'),
    PICTURE('P'),
    NUMERIC('N', 1, 32, 0, true),
    LONG('I', 4, 4, 4, false),
    AUTOINCREMENT('+', 4, 4, 4, false),
    CURRENCY('Y', 8, 8, 8, false),
    TIMESTAMP('T', 8, 8, 8, false),
    TIMESTAMP_DBASE7('@', 8, 8, 8, false),
    NULL_FLAGS('0');

    private byte code;
    private int minSize;
    private int maxSize;
    private int defaultSize;
    private boolean writeSupported = false;

    private DBFDataType(char code) {
        this((byte)code);
    }

    private DBFDataType(byte code) {
        this.code = code;
    }

    private DBFDataType(char code, int minSize, int maxSize, int defaultSize, boolean writeSupported) {
        this((byte)code, minSize, maxSize, defaultSize, writeSupported);
    }

    private DBFDataType(byte code, int minSize, int maxSize, int defaultSize, boolean writeSupported) {
        this.code = code;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.defaultSize = defaultSize;
        this.writeSupported = writeSupported;
    }

    public byte getCode() {
        return this.code;
    }

    public char getCharCode() {
        return (char)this.code;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public boolean isWriteSupported() {
        return this.writeSupported;
    }

    public static DBFDataType fromCode(byte code) {
        for (DBFDataType type : DBFDataType.values()) {
            if (code != type.code) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown data type:" + code);
    }

    public static DBFDataType fromCode(char code) {
        return DBFDataType.fromCode((byte)code);
    }
}

