/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.integration.vcs;

import com.github.avarabyeu.jashing.core.IncorrectConfigurationException;
import com.github.avarabyeu.jashing.integration.vcs.CompositeVCSClient;
import com.github.avarabyeu.jashing.integration.vcs.VCSClient;
import com.github.avarabyeu.jashing.integration.vcs.VCSConfiguration;
import com.github.avarabyeu.jashing.utils.ResourceUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;

public abstract class AbstractVcsModule
extends AbstractModule {
    public static final String VCS_CONFIG_JSON = "vcs-config.json";

    protected void configure() {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), VCSClient.class);
        this.getClients().stream().forEach(client -> multibinder.addBinding().toProvider(() -> client));
    }

    @Provides
    @Singleton
    public VCSClient vcsClient(Set<VCSClient> clients) {
        return new CompositeVCSClient(clients);
    }

    @Provides
    public VCSConfiguration loadConfiguration(Gson gson) {
        try {
            URL resource = ResourceUtils.getResourceAsURL((String)VCS_CONFIG_JSON);
            if (null == resource) {
                throw new IncorrectConfigurationException("Unable to find VCS configuration");
            }
            return (VCSConfiguration)gson.fromJson(Resources.asCharSource((URL)resource, (Charset)Charsets.UTF_8).openStream(), VCSConfiguration.class);
        }
        catch (IOException e) {
            throw new IncorrectConfigurationException("Unable to read VCS configuration", (Throwable)e);
        }
    }

    protected abstract List<VCSClient> getClients();
}

