/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.integration.vcs;

import com.github.avarabyeu.jashing.integration.vcs.AbstractVCSClient;
import com.github.avarabyeu.jashing.integration.vcs.VCSClient;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompositeVCSClient
extends AbstractVCSClient
implements VCSClient {
    private final Collection<VCSClient> delegates;

    public CompositeVCSClient(@Nonnull Collection<VCSClient> delegates) {
        this.delegates = delegates;
    }

    @Override
    public Map<String, Long> getCommitsPerUser(@Nonnull Instant from, @Nullable Instant to) {
        ArrayList results = new ArrayList(this.delegates.size());
        results.addAll(this.delegates.stream().map(delegate -> delegate.getCommitsPerUser(from, to)).collect(Collectors.toList()));
        return results.stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum));
    }

    @Override
    public long getCommitsForPeriod(@Nonnull Instant from, @Nullable Instant to) {
        return this.delegates.parallelStream().mapToLong(delegate -> delegate.getCommitsForPeriod(from, to)).sum();
    }
}

