/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.integration.vcs;

import com.github.avarabyeu.jashing.core.EventSource;
import com.github.avarabyeu.jashing.core.eventsource.ScheduledEventSource;
import com.github.avarabyeu.jashing.events.NumberEvent;
import com.github.avarabyeu.jashing.integration.vcs.AbstractVcsModule;
import com.github.avarabyeu.jashing.integration.vcs.VCSClient;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@EventSource(value="vcs-commits-progress-source", explicitConfiguration=AbstractVcsModule.class)
public class VCSCommitsProgressEventSource
extends ScheduledEventSource<NumberEvent> {
    @Inject
    private VCSClient vcsClient;
    private final Supplier<Long> yestardayCommitsCount = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Long>(){

        public Long get() {
            LocalDate today = LocalDate.now();
            return VCSCommitsProgressEventSource.this.vcsClient.getCommitsForPeriod(today.minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant(), today.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }, (long)1L, (TimeUnit)TimeUnit.HOURS);

    protected NumberEvent produceEvent() {
        Instant fromDateTime = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant();
        Long todaysCommitsCount = this.vcsClient.getCommitsForPeriod(fromDateTime);
        return new NumberEvent(todaysCommitsCount.intValue(), ((Long)this.yestardayCommitsCount.get()).intValue());
    }
}

