/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.integration.vcs;

import com.github.avarabyeu.jashing.core.EventSource;
import com.github.avarabyeu.jashing.core.eventsource.ScheduledEventSource;
import com.github.avarabyeu.jashing.events.ListEvent;
import com.github.avarabyeu.jashing.integration.vcs.AbstractVcsModule;
import com.github.avarabyeu.jashing.integration.vcs.VCSClient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@EventSource(value="vcs-top-committers-source", explicitConfiguration=AbstractVcsModule.class)
public class VCSTopCommitersEventSource
extends ScheduledEventSource<ListEvent<Long>> {
    private static final Comparator<ListEvent.Item<Long>> ITEM_COMPARATOR = Comparator.comparing(ListEvent.Item::getValue);
    @Inject
    private VCSClient svnClient;
    @Inject
    @Named(value="forPeriod")
    private Double daysBefore;

    protected ListEvent<Long> produceEvent() {
        LocalDateTime fromDateTime = LocalDate.now().minusDays(this.daysBefore.longValue()).atStartOfDay();
        Map<String, Long> commitsPerUser = this.svnClient.getCommitsPerUser(fromDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return new ListEvent(commitsPerUser.entrySet().stream().map(entry -> new ListEvent.Item((String)entry.getKey(), entry.getValue())).sorted(ITEM_COMPARATOR.reversed()).collect(Collectors.toList()));
    }
}

