/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaDeviceSubscribeService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.device.WxMaDeviceSubscribeMessageRequest;
import cn.binarywang.wx.miniapp.bean.device.WxMaDeviceTicketRequest;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;

public class WxMaDeviceSubscribeServiceImpl
implements WxMaDeviceSubscribeService {
    private final WxMaService service;

    @Override
    public String getSnTicket(WxMaDeviceTicketRequest deviceTicketRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/getsnticket", deviceTicketRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        String snTicket = jsonObject.get("sn_ticket").getAsString();
        return snTicket;
    }

    @Override
    public void sendDeviceSubscribeMsg(WxMaDeviceSubscribeMessageRequest deviceSubscribeMessageRequest) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/cgi-bin/message/device/subscribe/send", deviceSubscribeMessageRequest.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
    }

    public WxMaDeviceSubscribeServiceImpl(WxMaService service) {
        this.service = service;
    }
}

