/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenMaAuthService;
import me.chanjar.weixin.open.bean.auth.MaAuthQueryIdentityTreeResult;
import me.chanjar.weixin.open.bean.auth.MaAuthQueryResult;
import me.chanjar.weixin.open.bean.auth.MaAuthResubmitParam;
import me.chanjar.weixin.open.bean.auth.MaAuthSubmitParam;
import me.chanjar.weixin.open.bean.auth.MaAuthSubmitResult;
import me.chanjar.weixin.open.bean.auth.MaAuthUploadResult;

public class WxOpenMaAuthServiceImpl
implements WxOpenMaAuthService {
    private final WxMaService wxMaService;

    public WxOpenMaAuthServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public MaAuthSubmitResult submit(MaAuthSubmitParam param) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/sec/wxaauth", (Object)param);
        return (MaAuthSubmitResult)WxMaGsonBuilder.create().fromJson(response, MaAuthSubmitResult.class);
    }

    @Override
    public MaAuthQueryResult query(String taskId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/sec/queryauth", (Object)MapsKt.mapOf((Pair)new Pair((Object)"taskid", (Object)taskId)));
        return (MaAuthQueryResult)WxMaGsonBuilder.create().fromJson(response, MaAuthQueryResult.class);
    }

    @Override
    public MaAuthUploadResult upload(CommonUploadData data) throws WxErrorException {
        String response = this.wxMaService.upload("https://api.weixin.qq.com/wxa/sec/uploadauthmaterial", new CommonUploadParam("media", data));
        return (MaAuthUploadResult)WxMaGsonBuilder.create().fromJson(response, MaAuthUploadResult.class);
    }

    @Override
    public MaAuthSubmitResult resubmit(MaAuthResubmitParam param) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/sec/reauth", (Object)param);
        return (MaAuthSubmitResult)WxMaGsonBuilder.create().fromJson(response, MaAuthSubmitResult.class);
    }

    @Override
    public MaAuthQueryIdentityTreeResult queryIdentityTree() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/sec/authidentitytree", null);
        return (MaAuthQueryIdentityTreeResult)WxMaGsonBuilder.create().fromJson(response, MaAuthQueryIdentityTreeResult.class);
    }
}

