/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.util.SignUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.math.BigDecimal;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseWxPayRequest
implements Serializable {
    private static final long serialVersionUID = -4766915659779847060L;
    @XStreamAlias(value="appid")
    protected String appid;
    @XStreamAlias(value="mch_id")
    protected String mchId;
    @XStreamAlias(value="sub_appid")
    protected String subAppId;
    @XStreamAlias(value="sub_mch_id")
    protected String subMchId;
    @XStreamAlias(value="nonce_str")
    protected String nonceStr;
    @XStreamAlias(value="sign")
    protected String sign;
    @XStreamAlias(value="sign_type")
    private String signType;

    public static Integer yuanToFen(String yuan) {
        return new BigDecimal(yuan).setScale(2, 4).multiply(new BigDecimal(100)).intValue();
    }

    private void checkFields() throws WxPayException {
        try {
            BeanUtils.checkRequiredFields((Object)this);
        }
        catch (WxErrorException e) {
            throw new WxPayException(e.getError().getErrorMsg(), e);
        }
        this.checkConstraints();
    }

    protected abstract void checkConstraints() throws WxPayException;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public String toXML() {
        XStream xstream = XStreamInitializer.getInstance();
        this.setSubAppId(StringUtils.trimToNull((String)this.getSubAppId()));
        this.setSubMchId(StringUtils.trimToNull((String)this.getSubMchId()));
        xstream.processAnnotations(this.getClass());
        return xstream.toXML((Object)this);
    }

    protected boolean ignoreAppid() {
        return false;
    }

    protected String[] getIgnoredParamsForSign() {
        return new String[0];
    }

    public void checkAndSign(WxPayConfig config) throws WxPayException {
        this.checkFields();
        if (!this.ignoreAppid() && StringUtils.isBlank((CharSequence)this.getAppid())) {
            this.setAppid(config.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)this.getMchId())) {
            this.setMchId(config.getMchId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSubAppId())) {
            this.setSubAppId(config.getSubAppId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSubMchId())) {
            this.setSubMchId(config.getSubMchId());
        }
        if (StringUtils.isBlank((CharSequence)this.getSignType())) {
            if (config.getSignType() != null && !WxPayConstants.SignType.ALL_SIGN_TYPES.contains(config.getSignType())) {
                throw new WxPayException("\u975e\u6cd5\u7684signType\u914d\u7f6e\uff1a" + config.getSignType() + "\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
            }
            this.setSignType(StringUtils.trimToNull((String)config.getSignType()));
        } else if (!WxPayConstants.SignType.ALL_SIGN_TYPES.contains(this.getSignType())) {
            throw new WxPayException("\u975e\u6cd5\u7684sign_type\u53c2\u6570\uff1a" + this.getSignType());
        }
        if (StringUtils.isBlank((CharSequence)this.getNonceStr())) {
            this.setNonceStr(String.valueOf(System.currentTimeMillis()));
        }
        this.setSign(SignUtils.createSign(this, this.getSignType(), config.getMchKey(), this.getIgnoredParamsForSign()));
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public String getSignType() {
        return this.signType;
    }

    public BaseWxPayRequest setSubAppId(String subAppId) {
        this.subAppId = subAppId;
        return this;
    }

    public BaseWxPayRequest setSubMchId(String subMchId) {
        this.subMchId = subMchId;
        return this;
    }

    public BaseWxPayRequest setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public BaseWxPayRequest setSignType(String signType) {
        this.signType = signType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWxPayRequest)) {
            return false;
        }
        BaseWxPayRequest other = (BaseWxPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$subMchId = this.getSubMchId();
        String other$subMchId = other.getSubMchId();
        if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        return !(this$signType == null ? other$signType != null : !this$signType.equals(other$signType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWxPayRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $subMchId = this.getSubMchId();
        result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        return result;
    }
}

