/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.marketing.BusiFavorCallbacksRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCallbacksResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponCodeRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponCodeResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsAssociateRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsAssociateResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsDeactivateRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsDeactivateResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsReturnRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsReturnResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsUrlRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsUseRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorCouponsUseResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorNotifyRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorNotifyResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorQueryOneUserCouponsRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorQueryOneUserCouponsResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorQueryUserCouponsRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorQueryUserCouponsResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorStocksBudgetRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorStocksBudgetResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorStocksCreateRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorStocksCreateResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorStocksGetResult;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorSubsidyRequest;
import com.github.binarywang.wxpay.bean.marketing.BusiFavorSubsidyResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.MarketingBusiFavorService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketingBusiFavorServiceImpl
implements MarketingBusiFavorService {
    private static final Logger log = LoggerFactory.getLogger(MarketingBusiFavorServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public BusiFavorStocksCreateResult createBusiFavorStocksV3(BusiFavorStocksCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/stocks", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorStocksCreateResult)GSON.fromJson(result, BusiFavorStocksCreateResult.class);
    }

    @Override
    public BusiFavorStocksGetResult getBusiFavorStocksV3(String stockId) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/stocks/%s", this.payService.getPayBaseUrl(), stockId);
        String result = this.payService.getV3(url);
        return (BusiFavorStocksGetResult)GSON.fromJson(result, BusiFavorStocksGetResult.class);
    }

    @Override
    public BusiFavorCouponsUseResult verifyBusiFavorCouponsUseV3(BusiFavorCouponsUseRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/coupons/use", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponsUseResult)GSON.fromJson(result, BusiFavorCouponsUseResult.class);
    }

    @Override
    public String buildBusiFavorCouponinfoUrl(BusiFavorCouponsUrlRequest request) throws WxPayException {
        HashMap<String, String> signMap = new HashMap<String, String>(8);
        signMap.put("out_request_no", request.getOutRequestNo());
        signMap.put("stock_id", request.getStockId());
        signMap.put("send_coupon_merchant", request.getSendCouponMerchant());
        signMap.put("open_id", request.getOpenid());
        String sign = SignUtils.createSign(signMap, "HMAC-SHA256", this.payService.getConfig().getMchKey(), null);
        String actionBaseUrl = "https://action.weixin.qq.com";
        return String.format("%s/busifavor/getcouponinfo?stock_id=%s&out_request_no=%s&sign=%s&send_coupon_merchant=%s&open_id=%s#wechat_redirect", actionBaseUrl, request.getStockId(), request.getOutRequestNo(), sign, request.getSendCouponMerchant(), request.getOpenid());
    }

    @Override
    public BusiFavorQueryUserCouponsResult queryBusiFavorUsersCoupons(BusiFavorQueryUserCouponsRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/users/%s/coupons", this.payService.getPayBaseUrl(), request.getOpenid());
        if (request.getOffset() == null) {
            request.setOffset(0);
        }
        if (request.getLimit() == null || request.getLimit() <= 0) {
            request.setLimit(20);
        }
        String query = String.format("?appid=%s&offset=%s&limit=%s", request.getAppid(), request.getOffset(), request.getLimit());
        if (StringUtils.isNotBlank((CharSequence)request.getStockId())) {
            query = query + "&stock_id=" + request.getStockId();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCouponState())) {
            query = query + "&coupon_state=" + request.getCouponState();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCreatorMerchant())) {
            query = query + "&creator_merchant=" + request.getCreatorMerchant();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getBelongMerchant())) {
            query = query + "&belong_merchant=" + request.getBelongMerchant();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSenderMerchant())) {
            query = query + "&sender_merchant=" + request.getSenderMerchant();
        }
        String result = this.payService.getV3(url + query);
        return (BusiFavorQueryUserCouponsResult)GSON.fromJson(result, BusiFavorQueryUserCouponsResult.class);
    }

    @Override
    public BusiFavorQueryOneUserCouponsResult queryOneBusiFavorUsersCoupons(BusiFavorQueryOneUserCouponsRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/users/%s/coupons/%s/appids/%s", this.payService.getPayBaseUrl(), request.getOpenid(), request.getCouponCode(), request.getAppid());
        String result = this.payService.getV3(url);
        return (BusiFavorQueryOneUserCouponsResult)GSON.fromJson(result, BusiFavorQueryOneUserCouponsResult.class);
    }

    @Override
    public BusiFavorCouponCodeResult uploadBusiFavorCouponCodes(String stockId, BusiFavorCouponCodeRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/stocks/%s/couponcodes", this.payService.getPayBaseUrl(), stockId);
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponCodeResult)GSON.fromJson(result, BusiFavorCouponCodeResult.class);
    }

    @Override
    public BusiFavorCallbacksResult createBusiFavorCallbacks(BusiFavorCallbacksRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/callbacks", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCallbacksResult)GSON.fromJson(result, BusiFavorCallbacksResult.class);
    }

    @Override
    public BusiFavorCallbacksResult queryBusiFavorCallbacks(BusiFavorCallbacksRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/callbacks", this.payService.getPayBaseUrl());
        if (StringUtils.isNotBlank((CharSequence)request.getMchid())) {
            url = url + "?mchid=" + request.getMchid();
        }
        String result = this.payService.getV3(url);
        return (BusiFavorCallbacksResult)GSON.fromJson(result, BusiFavorCallbacksResult.class);
    }

    @Override
    public BusiFavorCouponsAssociateResult queryBusiFavorCouponsAssociate(BusiFavorCouponsAssociateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/coupons/associate", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponsAssociateResult)GSON.fromJson(result, BusiFavorCouponsAssociateResult.class);
    }

    @Override
    public BusiFavorCouponsAssociateResult queryBusiFavorCouponsDisAssociate(BusiFavorCouponsAssociateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/coupons/disassociate", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponsAssociateResult)GSON.fromJson(result, BusiFavorCouponsAssociateResult.class);
    }

    @Override
    public BusiFavorStocksBudgetResult updateBusiFavorStocksBudget(String stockId, BusiFavorStocksBudgetRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/stocks/%s/budget", this.payService.getPayBaseUrl(), stockId);
        String result = this.payService.patchV3(url, GSON.toJson((Object)request));
        return (BusiFavorStocksBudgetResult)GSON.fromJson(result, BusiFavorStocksBudgetResult.class);
    }

    @Override
    public String updateBusiFavorStocksV3(String stockId, BusiFavorStocksCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/stocks/%s", this.payService.getPayBaseUrl(), stockId);
        return this.payService.patchV3(url, GSON.toJson((Object)request));
    }

    @Override
    public BusiFavorCouponsReturnResult returnBusiFavorCoupons(BusiFavorCouponsReturnRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/coupons/return", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponsReturnResult)GSON.fromJson(result, BusiFavorCouponsReturnResult.class);
    }

    @Override
    public BusiFavorCouponsDeactivateResult deactiveBusiFavorCoupons(BusiFavorCouponsDeactivateRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/coupons/deactivate", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorCouponsDeactivateResult)GSON.fromJson(result, BusiFavorCouponsDeactivateResult.class);
    }

    @Override
    public BusiFavorSubsidyResult subsidyBusiFavorPayReceipts(BusiFavorSubsidyRequest request) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/subsidy/pay-receipts", this.payService.getPayBaseUrl());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorSubsidyResult)GSON.fromJson(result, BusiFavorSubsidyResult.class);
    }

    @Override
    public BusiFavorSubsidyResult queryBusiFavorSubsidyPayReceipts(String subsidyReceiptId) throws WxPayException {
        String url = String.format("%s/v3/marketing/busifavor/subsidy/pay-receipts/%s", this.payService.getPayBaseUrl(), subsidyReceiptId);
        String result = this.payService.getV3(url);
        return (BusiFavorSubsidyResult)GSON.fromJson(result, BusiFavorSubsidyResult.class);
    }

    @Override
    public BusiFavorNotifyResult notifyBusiFavor(String url, BusiFavorNotifyRequest request) throws WxPayException {
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BusiFavorNotifyResult)GSON.fromJson(result, BusiFavorNotifyResult.class);
    }

    public MarketingBusiFavorServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

