/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.auth;

import com.github.binarywang.wxpay.v3.Validator;
import com.github.binarywang.wxpay.v3.auth.Verifier;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(WxPayValidator.class);
    private final Verifier verifier;

    public WxPayValidator(Verifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public final boolean validate(CloseableHttpResponse response) throws IOException {
        if (!ContentType.APPLICATION_JSON.getMimeType().equals(ContentType.parse((String)String.valueOf(response.getFirstHeader("Content-Type").getValue())).getMimeType())) {
            return true;
        }
        Header serialNo = response.getFirstHeader("Wechatpay-Serial");
        Header sign = response.getFirstHeader("Wechatpay-Signature");
        Header timestamp = response.getFirstHeader("Wechatpay-TimeStamp");
        Header nonce = response.getFirstHeader("Wechatpay-Nonce");
        if (timestamp == null || nonce == null || serialNo == null || sign == null) {
            return false;
        }
        String message = this.buildMessage(response);
        return this.verifier.verify(serialNo.getValue(), message.getBytes(StandardCharsets.UTF_8), sign.getValue());
    }

    protected final String buildMessage(CloseableHttpResponse response) throws IOException {
        String timestamp = response.getFirstHeader("Wechatpay-TimeStamp").getValue();
        String nonce = response.getFirstHeader("Wechatpay-Nonce").getValue();
        String body = this.getResponseBody(response);
        return timestamp + "\n" + nonce + "\n" + body + "\n";
    }

    protected final String getResponseBody(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        return entity != null && entity.isRepeatable() ? EntityUtils.toString((HttpEntity)entity) : "";
    }
}

